<?php

namespace Mnv\Models\Users;


class UserTypes
{
    const ADMIN     = 'A';
    const DEVELOPER = 'D';
    const CUSTOMER  = 'C';
    const VENDOR    = 'V';

    /**
     * @param string $user_type User type
     *
     * @return bool
     */
    public static function isVendor(string $user_type): bool
    {
        return $user_type === self::VENDOR;
    }
    /**
     * @param string $user_type User type
     *
     * @return bool
     */
    public static function isDeveloper(string $user_type): bool
    {
        return $user_type === self::DEVELOPER;
    }
    /**
     * @param string $user_type User type
     *
     * @return bool
     */
    public static function isAdmin(string $user_type): bool
    {
        return $user_type === self::ADMIN;
    }

    /**
     * @param string $user_type User type
     *
     * @return bool
     */
    public static function isCustomer(string $user_type): bool
    {
        return $user_type === self::CUSTOMER;
    }

}