<?php

namespace Mnv\Modules\Filter;

use Mnv\Core\Utilities\Cookie\Cookie;

class FilterProducts
{
    /**
     * Текущий список ID новостей закладок
     * @var array
     */
    private $list = [];


    public $countFavorite = 0;

    /**
     * Конструктор класса
     */
    public function __construct()
    {
        $this->loadList();
    }


    /**
     * Добавление/удаление новости в закладки
     * @param  integer $id ID новости
     * @return string текст ошибки
     */
    public function setId($id = 0)
    {
        $id = (int)$id;
        if ($id < 1) {
            return 'Не задан ID';
        }

        if (isset($this->list[$id])) {
            unset($this->list[$id]);
            $list = array_keys($this->list);
        } else {
            $list = array_keys($this->list);
            array_unshift($list, $id);
        }

        $this->countFavorite = count($list);

        $list = join(',', $list);

        Cookie::setcookie('_favorites', $list, \time() + 3600 * 24 * 1000, "/");
    }

    /**
     * Получение текущего массива ID закладок
     * @return array
     */
    public function getList()
    {
        $list = array_keys($this->list);
        if (!$list) {
            $list[] = 0;
        }
        return $list;
    }

    /**
     * Получение списка закладок
     * @return void
     */
    private function loadList()
    {
        $list = Cookie::get('_favorites');
        $list = $list ? explode(',', $list) : [];
        if ($list) {
            foreach ($list as $v) {
                $v = (int)$v;
                if ($v > 0) {
                    $this->list[$v] = true;
                }
            }
        }
    }
}