<?php
namespace Mnv\Modules;

use Mnv\Core\DB;
use Mnv\Core\Locale\I18N;
use Mnv\Core\Mnv;

require_once GLOBAL_ROOT . '/includes/admin-functions.inc.php';

/**
 * Class Newsletter
 * @package Mnv\Modules
 */
class Newsletter extends Mnv
{
    private static $email;
    private static $datetime = null;
    private static $valid = true;

    public function register(?string $email): array
    {
        self::$email    = $email;
        self::$datetime = date('Y-m-d H:i:s');

        if (empty(self::$email)) {

            $status  = "error";
            $message = I18N::locale("Поле email адреса не должно быть пустым.", "Elektron pochta maydoni bo'sh bo'lmasligi kerak", "The email field should not be empty");
            //"Поле email адреса не должно быть пустым.";
            self::$valid = false;

        } else if (!filter_var(self::$email, FILTER_VALIDATE_EMAIL)) {

            $status  = "error";
            $message = I18N::locale("Вы должны заполнить поле действительным адресом электронной почты", "Maydonni haqiqiy elektron pochta manzili bilan to'ldirishingiz kerak", "You must fill in the field with a valid email address");
            self::$valid = false;
        }

        if (self::$valid) {
            $existingSignup = DB::init()->connect()->table('subscribe')->count('*')->where('email', $email)->getValue();
            $data_exists = $existingSignup > 0;

            if (!$data_exists) {
                $status = DB::init()->connect()->table('subscribe')->insert(['email' => self::$email, 'registered'=> self::$datetime]);
                if ($status) {
                    $status  = "success";
                    $message = I18N::locale("Вы успешно подписаны.", "Siz muvaffaqiyatli imzolandingiz", "You have been successfully subscribed");
                } else {
                    $status  = "error";
                    $message = I18N::locale("Произошла ошибка. Пожалуйста, попробуйте еще раз.", "Xato yuz berdi. Iltimos, yana urinib ko'ring", "An error has occurred. Please try again");
                }
            } else {
                $status  = "error";
                $message = I18N::locale("Это email уже подписан", "Ushbu elektron pochta allaqachon imzolangan", "This email is already signed");
            }
        }

        return array('status'  => $status, 'message' => $message);

    }

}