<?php

namespace Mnv\Modules\Payment\Click\Form;

use Mnv\Modules\Payment\PaymentMethodService;
use Mnv\Modules\Payment\PaymentMethodInterface;

/**
 * Class ClickGenerationForm
 * @package Mnv\Api\Payment
 */
final class ClickGenerationForm implements PaymentMethodInterface
{

//    const RETURN_URL = SITE_URL.'/api-click.php';

    private $MERCHANTID;
    private $SERVICEID;
    private $SECTETKEY;

    public function __construct()
    {
        $payment = new PaymentMethodService('click');
        $this->MERCHANTID = $payment->payment_method->settings->merchant_id;
        $this->SERVICEID  = $payment->payment_method->settings->service_id;
        $this->SECTETKEY  = $payment->payment_method->settings->secret_key;
    }

	public function form(int $orderId, float $amount, int $userId = null, string $fullName = null, string $userPhone = null, string $userEmail = null, array $note = null, string $lang = null, bool $auto = true): ?string
    {
    	 
		if (!$orderId) return null;

        $button = '<button type="submit" class="send">Перейти к оплате</button>';
		if ($auto) {
            $button = '';
            $auto = '<script type="text/javascript">clickPayment.submit()</script>';
		}
        
		$fields = $this->fields($orderId, $amount, $userId, $fullName, $userPhone, $userEmail, $note, $lang);

        return <<<HTML
<form action="https://my.click.uz/pay/" name="clickPayment" method="post" target="_blank">
{$fields}
{$button}
</form>
{$auto}
HTML;

	}


	public function fields(int $orderId, float $amount, int $userId = null, string $fullName = null, string $userPhone = null, string $userEmail = null, array $note = null, string $lang = null): string
    {

		$date   = date("Y-m-d h:i:s");
		$amount = number_format($amount, 2, '.', '');
       
		$fields = array(
			'MERCHANT_ID'           => $this->MERCHANTID,
			'MERCHANT_SERVICE_ID'   => $this->SERVICEID,
			'MERCHANT_TRANS_ID'     => $orderId,
			'MERCHANT_TRANS_AMOUNT' => $amount,
			'MERCHANT_TRANS_NOTE'   => join(', ', $note),
			'MERCHANT_USER_PHONE'   => $userPhone,
			'MERCHANT_USER_EMAIL'   => $userEmail,
			'SIGN_TIME'             => $date,
			'SIGN_STRING'           => md5($date . $this->SECTETKEY . $this->SERVICEID . $orderId . $amount),
			'RETURN_URL'            => SITE_URL,
		);
        
		$html = '';

		foreach ($fields as $field => $val) {
			$html .= '<input type="hidden" name="' . $field . '" value="' . $val . '" />' . PHP_EOL;
		}

		return $html;
	}
	
}


