<?php

namespace Mnv\Modules\Payment\Paybox\Form;

use Mnv\Modules\Payment\Paybox\PayBoxApi;
use Mnv\Modules\Payment\Paybox\PG_Signature;
use Mnv\Modules\Payment\PaymentMethodInterface;

class PayboxGenerationForm implements PaymentMethodInterface
{

    private $paybox;

    public function __construct()
    {
        $this->paybox = new PayBoxApi();
        $this->paybox->getDefaultCurrency();
    }

    public function form(int $orderId, float $amount, int $userId = null, string $fullName = null, string $userPhone = null, string $userEmail = null, array $note = null, string $lang = null, bool $auto = true): ?string
    {
        if (!$orderId) return null;

        $button = '<button type="submit" class="send">Перейти к оплате</button>';
        if ($auto) {
            $button = '';
            $auto = '<script type="text/javascript">payboxPayment.submit()</script>';
        }

        $fields = $this->fields($orderId, $amount, $userId, $fullName, $userPhone, $userEmail, $note, $lang);

        return <<<HTML
<form action='https://api.paybox.money/payment.php' name="payboxPayment" method="POST" target="_blank">

{$fields}
{$button}
</form>
{$auto}
HTML;
    }

    public function fields(int $orderId, float $amount, int $userId = null, string $fullName = null, string $userPhone = null, string $userEmail = null, array $note = null, string $lang = null): ?string
    {

// TODO: 2 конвертировать `$amount` в валюту
        $amount = $this->paybox->convertMoney($amount);

//        print_r($amount);
//        print_r($this->paybox->currency);

        $success_url = GLOBAL_URL.'/callback_success/'; // пока не известно
        $failure_url = GLOBAL_URL.'/callback_failure/';
        $server_url = GLOBAL_URL.'/payments/paybox/index.php';

        $arrFields = array(
            'pg_merchant_id'		=> PayBoxApi::MERCHANTID,
            'pg_order_id'			=> $orderId,
            'pg_currency'			=> $this->paybox->currency,
            'pg_amount'				=> number_format($amount, 2, '.', ''), // intval($amount),
            'pg_lifetime'			=> (PayBoxApi::TRANSACTION_LIFETIME) ? PayBoxApi::TRANSACTION_LIFETIME*60 : 0,
            'pg_testing_mode'		=> (PayBoxApi::MODE  == 'sandbox') ? 1 : 0 ,
            'pg_description'		=> 'Покупка в интернет магазине "PowerGym". Номер заказа #'.$orderId,  //$strDescription,
            'pg_user_ip'			=> $_SERVER['REMOTE_ADDR'],
            'pg_language'			=> $lang,
            'pg_check_url'			=> $server_url,
            'pg_result_url'			=> $server_url,
            'pg_success_url'		=> $success_url,
            'pg_failure_url'		=> $failure_url,
            'pg_request_method'		=> 'GET',
            'cms_payment_module'	=> 'LS',
            'pg_salt'				=> rand(21,43433), // Параметры безопасности сообщения. Необходима генерация pg_salt и подписи сообщения.
        );

        if (!empty($userPhone)) {
            $arrFields['pg_user_phone'] = $userPhone;
        }

        if (!empty($userEmail)) {
            $arrFields['pg_user_email'] = $userEmail;
            $arrFields['pg_user_contact_email'] = $userEmail;
        }
        if (!empty($this->paybox->payment_system))
            $arrFields['pg_payment_system'] = $this->paybox->payment_system;

        // подпись
        $arrFields['pg_sig'] = PG_Signature::make('payment.php', $arrFields, PayBoxApi::SECTETKEY);


//        print_r($arrFields);

        $html = '';
        foreach ($arrFields as $strParamName => $strParamValue) {
            $html .= "<input type=hidden name='$strParamName' value='$strParamValue'>";
        }

        return $html;
    }
}