<?php

namespace Mnv\Modules\Shop;

use Mnv\Core\DB;

/**
 * Class Product
 * @package Mnv\Modules\Shop
 */
class Product extends Repository
{
    private static $table = 'articles';

    public $item = array();

//    public int $articleId;
//    public string $price;
//    public string $amount;

    public function getProduct(?int $productId, ?int $variantId)
    {
        if ($this->item = DB::init()->connect()->table(self::$table)->select('articleId, title')->where('articleId', $productId)->get()) {
            if ($variants = DB::init()->connect()->table('product_variants')->orderBy('orderBy')->where('productId', $this->item->articleId)->where('id', $variantId)->get()) {
                $this->item->variants = $variants;
            }
//            print_r($this->item);
            return $this->item;
        }

    }

    public function getVariant(?int $variantId)
    {
        // TODO: join запрос
        $this->item = DB::init()->connect()->table('product_variants')
            ->select('title, id AS variantId, productId, name AS variantName, sku, price, oldPrice, stock')
            ->join(self::$table, 'articleId', '=', 'productId')->where('id', $variantId)->get();
            return $this->item;
    }

//    public function getProductStock($articleId)
//    {
//        if ($article = DB::init()->connect()->table(self::$table)->select('stock')->where('articleId', '=', $articleId)->get()) return $article->stock;
//
//        return false;
//    }
}