<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

use Mnv\Core\DB;
use Mnv\Core\Utilities\Cookie\Session;

function smarty_function_fetch_baskets($params, &$smarty){
	
	$assign        = fetch_getParam('assign', $params, 'baskets');
    //$fields        = fetch_getParam('fields', $params, 'articleId, sectionId, publishedOn, title, alias, url, summary, orderBy, price, oldPrice, typeContent');
	$status        = fetch_getParam('status', $params, 'visible');
	$limit         = (int) fetch_getParam('limit', $params);
	$perPage       = (int) fetch_getParam('perPage', $params, $limit);

	$typeContent  = fetch_getParam('typeContent', $params, 'products');	
	
	$userId        = (int) fetch_getParam('userId', $params);
	$token         = (int) fetch_getParam('token', $params);

	
	$image        = fetch_getParam('image', $params, false);
	$image_type   = fetch_getParam('image_type', $params, 'general');
	
	$sectionInfo  = fetch_getParam('sectionInfo', $params, false);
	$parentsInfo  = fetch_getParam('parentsInfo', $params, false);
	
	
	if (empty($assign)) {
		$smarty->_trigger_fatal_error('fetch_baskets: "assign" must not be empty');
		return;
	}

	$totalPrice = 0;
    $baskets = array();

	if (Session::has('token') && Session::has('basket')) {

        if ($baskets = DB::init()->connect()->table('shop_baskets')->select('basketId, variantIds, products, quantity, amount')->where('token', Session::get('token'))->get('array')) {
            $baskets['products'] = json_decode($baskets['products']);
            foreach ($baskets['products'] as $productId => $product) {
                $variant = DB::init()->connect()->table('product_variants')
                    ->select('articleId, title, brand, url, special, id AS variantId, productId, name AS variantName, sku, price, oldPrice, fileId, info')
                    ->join('articles', 'articleId', '=', 'productId')->usingJoin('article_images', 'articleId')->usingJoin('files', 'fileId')->where('type', 'general')
                    ->where('productId', $product['productId'])->get();

                $baskets['products'][$productId]['title'] = $variant['title'];
                $baskets['products'][$productId]['special'] = $variant['special'];
                $baskets['products'][$productId]['brand'] = DB::init()->connect()->table('brands')->select('name')->where('fileName', $variant->brand)->getValue();
                $baskets['products'][$productId]['oldPrice'] = $variant['oldPrice'];
                $baskets['products'][$productId]['url'] = $variant->url;
                if (!empty($variant['info'])) {
                    $variant['info'] = json_decode($variant['info']);
                }
            }
        }
    }

    $smarty->assign($assign, $baskets);


}
function firstElement($params = array())
{
    if(!is_array($params)) {
        return false;
    }
    return reset($params);
}
?>