<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

use Mnv\Core\DB;
use Mnv\Models\Features;
use Mnv\Models\Variants;

function smarty_function_fetch_product($params, &$smarty) {

	$assign        = fetch_getParam('assign', $params, 'product');
	$fields        = fetch_getParam('fields', $params, 'articleId, sectionId, publishedOn, title, alias, url, brand');
	$status        = fetch_getParam('status', $params, 'visible');
	$productId     = (int) fetch_getParam('articleId', $params);

	/* conditions */
	if (!empty($status)) DB::init()->connect()->where('status', $status);
	if ($productId > 0) DB::init()->connect()->where('articleId', $productId);

    $variantProduct = new Variants();
    $features = new Features();
    if ($product =  DB::init()->connect()->table('articles')->select($fields)->get('array')) {

        $product = prepareArticle($product);

        $product['features'] = $features->getProductOptions($product['articleId']);
        $variants = $variantProduct->getVariants($product['articleId']);
        if (!empty($variants)) {
            foreach ($variants as $variantId => &$variant) {
                $product['variants'][$variantId] = $variant;
            }
        }
    }

//	print_r($product);
	$smarty->assign($assign, $product);


	return null;
}
?>