<?php
	include '../includes/overall.inc.php';

use Mnv\Core\Bot\Exceptions\InvalidChatIdException;
use Mnv\Core\Bot\Exceptions\InvalidTokenException;
use Mnv\Core\Bot\Telegram;
use Mnv\Core\Config;
use Mnv\Core\Feedback;
use Mnv\Core\Locale\I18N;
use Mnv\Core\Validations\ValidateEmail;

//global $smarty;
	
	$feedbackClass = new Feedback(Config::getValue('mail_transport'));
    $feedbackClass->getCaptchaEnabled(Config::getValue('feedback_captcha_enabled'));
    $feedbackClass->getAllowCaptcha(Config::getValue('allow_recaptcha'));

    $error    = '';
    $response  = null;
    $captchaGood = false;
    $attachment = null;

    $rewrite   = getRequestVar('rewrite');
    $feedback   = getRequestVar('feedback', '', true);
    $bot        = getRequestVar('bot', '', true);


    if ($rewrite != Config::getValue('rewrite')) {
        header("HTTP/1.0 301 Moved Permanently");
        header("Location: " . SITE_URL);

        exit;
    }


    if (isset($_FILES) && !empty($_FILES['file'])) {
        $attachment = $_FILES['file'];
    }

    if (empty($feedback['subject'])) {
        $feedback['subject'] = Config::getValue('smtp_subject');
    }
    $feedback['subject'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($feedback['subject']));



    /* checking whether message is empty */
//    if (empty($feedback['message'])) {
//        $feedbackClass->errors = 'message';
//    }


    if (empty($feedbackClass->errors)) {

        $arrayMessage = array_filter([
            'Дата отправки сообщения' => adjustTime(gmdate('d-m-Y H:i'), false, 'd-m-Y H:i'),
            'Ф.И.О.'        => $feedback['fullName'],
            'Телефон'       => $feedback['phone']
        ]);

        $htmlBody = '';
        foreach($arrayMessage as $key => $value) {
            $htmlBody .= "<b>".$key.":</b> ".$value."<br />";
        }

        /* проверка включена капча */
        if ($feedbackClass->setCaptchaEnabled() == 1) {
            /* вид каптчи */
            if ($feedbackClass->setAllowCaptcha() == 1) {
                if (empty($feedbackClass->errors) && $feedbackClass->captchaToken($_POST['token'])) {
                    $captchaGood = true;
                } else {
                    $response = array('status' => 400, 'message' => $feedbackClass->errors, 'color' => 'red');
                }
            } else {
                if (empty($feedbackClass->errors) && $feedbackClass->antiBot($bot['anti-bot-a'], $bot['anti-bot-q'], $bot['anti-email'])) {
                    $captchaGood = true;
                } else {
                    $response = array('status' => 400, 'message' => $feedbackClass->errors, 'color' => 'red');
                }
            }
        }
        /* если все good то пропускаем на отправку */
        if (empty($feedbackClass->errors) && $captchaGood == true) {
            /* отправка в телеграм */
            try {
                Telegram::send(Config::getValue('telegram_send'), Config::getValue('telegram_token'), Config::getValue('telegram_chat_id'),  br2nl("<b>" . $feedback['subject'] . "</b><br>" .$htmlBody));
            } catch (InvalidChatIdException $e) {
                $feedbackClass->errors =  I18N::locale("Telegram bot setting Empty token", "Telegram bot setting Empty token", "Telegram bot setting Empty token");
            } catch (InvalidTokenException $e) {
                $feedbackClass->errors =  I18N::locale("Telegram bot setting empty chat_id", "Telegram bot setting Empty chat_id", "Telegram bot setting Empty chat_id");
            }
            /* отправка по smtp */
            try {
                if (empty($feedbackClass->errors) && $feedbackClass->send($feedback['fullName'], $feedback['phone'], $feedback['subject'], $htmlBody, $attachment)) {
                    $response = array(
                        'status' => 200, 'color' => 'green',
                        'message' => I18N::locale("Ваше сообщение успешно отправлено", "Sizning xabaringiz muvaffaqiyatli yuborildi", "Your message has been sent successfully")
                    );
                    $feedbackClass->insertMail($feedback['fullName'], $feedback['phone'], $feedback['subject'], $htmlBody);
                } else {
                    $response = array('status' => 400, 'message' => $feedbackClass->errors, 'color' => 'red');
                }
            } catch (\PHPMailer\PHPMailer\Exception $e) {
                $response = array('status' => 400, 'message' => $e->getMessage(), 'color' => 'red');
            }
        }
    } else {
        $response = array('status' => 400, 'message' => $feedbackClass->errors, 'color' => 'red');
    }


    return response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
  

