import { forAjax } from './forAjax.js'

export const validateForm = (form) => {
    // внутрение функции
    function _arrInputEmpty(arr) {
        return [...arr]
            .filter((x) => x.getAttribute('data-empty'))
            .filter((x) => x.type != 'checkbox')
            .filter((x) => x.type != 'file')
            .filter((x) => x.type != 'password')
            .filter((x) => !x.classList.contains('not-valid'))
    }

    function _arrMailEmpty(arr) {
        return [...arr].filter((x) => x.getAttribute('data-mail')).filter((x) => !x.value.includes('@'))
    }

    function _arrCheckboxEmpty(arr) {
        return [...arr].filter((x) => x.type === 'checkbox').filter((x) => !x.classList.contains('not-valid'))
    }

    function _arrFileEmpty(arr) {
        return [...arr]
            .filter((x) => x.type === 'file')
            .filter((x) => !x.classList.contains('not-valid'))
            .filter((x) => x.value === '')
    }

    function _arrPasswordEmpty(arr) {
        return [...arr]
            .filter((x) => x.type == 'password')
            .filter((x) => !x.classList.contains('not-valid'))
            .filter((x) => x.value === '')
    }

    function _creatAtention(itemParent, field, text) {
        let atentionHas = itemParent.querySelector('.text-empty')

        if (!atentionHas) {
            _removeAtention(itemParent)

            let atention = document.createElement('div')
            atention.textContent = field.getAttribute(text)
            atention.classList.add('text-empty')

            itemParent.insertAdjacentElement('beforeend', atention)
        }
    }

    function _removeAtention(itemParent) {
        let atentionHas = itemParent.querySelector('.text-empty')

        if (atentionHas) {
            atentionHas.remove()
        }
    }

    function _mainDate(inputEmptyArr, mailEmptyArr, chekboxEmptyInputArr, fileInputArr, passwordInputArr, btnSubmite, textareaNode, inputNode) {
        inputEmptyArr = _arrInputEmpty([...textareaNode, ...inputNode]).filter((x) => x.value.replace(/ /g, '').length < 1)
        mailEmptyArr = _arrMailEmpty(inputNode)
        chekboxEmptyInputArr = _arrCheckboxEmpty(inputNode).filter((x) => x.checked != true)
        fileInputArr = _arrFileEmpty(inputNode)
        passwordInputArr = _arrPasswordEmpty(inputNode)

        let inputArrBoolean = [!inputEmptyArr.length]

        inputArrBoolean.push(!mailEmptyArr.length)
        inputArrBoolean.push(!chekboxEmptyInputArr.length)
        inputArrBoolean.push(!fileInputArr.length)
        inputArrBoolean.push(!passwordInputArr.length)

        btnSubmite.classList[inputArrBoolean.some((x) => !x) ? 'remove' : 'add']('valid-success')
    }

    // Начало
    let formNode = document.querySelectorAll(form)

    for (let index = 0; index < formNode.length; index++) {
        const form = formNode[index]

        let inputNode = form.querySelectorAll('input'),
            textareaNode = form.querySelectorAll('textarea'),
            btnSubmite = form.querySelector('[type="submit"]'),
            inputEmptyArr = _arrInputEmpty([...textareaNode, ...inputNode]),
            mailEmptyArr = _arrMailEmpty(inputNode),
            chekboxEmptyInputArr = _arrCheckboxEmpty(inputNode),
            fileInputArr = _arrFileEmpty(inputNode),
            passwordInputArr = _arrPasswordEmpty(inputNode)

        form.onsubmit = function () {
            if (!btnSubmite.classList.contains('valid-success')) {
                return false
            }
        }

        form.oninput = function () {
            _mainDate(inputEmptyArr, mailEmptyArr, chekboxEmptyInputArr, fileInputArr, passwordInputArr, btnSubmite, textareaNode, inputNode)
        }

        _mainDate(inputEmptyArr, mailEmptyArr, chekboxEmptyInputArr, fileInputArr, passwordInputArr, btnSubmite, textareaNode, inputNode)

        // инпуты пустые
        inputEmptyArr.forEach((el) => {
            el.onfocus = function () {
                el.parentElement.classList.remove('input-error')
                _removeAtention(el.parentElement)
            }

            el.onblur = function () {
                if (el.value.replace(/ /g, '').length < 1) {
                    el.parentElement.classList.add('input-error')
                    _creatAtention(el.parentElement, el, 'data-empty')
                }
            }
        })

        // инпут пароль
        passwordInputArr.forEach((el) => {
            el.onfocus = function () {
                el.parentElement.classList.remove('input-error')
                _removeAtention(el.parentElement)
            }

            el.onblur = function () {
                if (el.value.replace(/ /g, '').length < 1) {
                    el.parentElement.classList.add('input-error')
                    _creatAtention(el.parentElement, el, 'data-empty')
                }
            }
        })

        // инпуты почты
        mailEmptyArr.forEach((el) => {
            el.onblur = function () {
                if (el.getAttribute('data-mail') && !el.value.includes('@')) {
                    el.parentElement.classList.add('input-error')
                    _creatAtention(el.parentElement, el, 'data-mail')
                }
            }
        })

        // чекбоксы
        chekboxEmptyInputArr.forEach((el) => {
            el.oninput = function () {
                el.parentElement.classList.toggle('input-error', !el.checked)
            }
        })

        // инпут файл
        fileInputArr.forEach((el) => {
            el.onchange = function () {
                el.parentElement.classList.toggle('input-error', el.value === '')
            }
        })

        // кнопка сабмит
        btnSubmite.onclick = function (e) {
            e.preventDefault()

            inputEmptyArr = _arrInputEmpty([...textareaNode, ...inputNode]).filter((x) => x.value.replace(/ /g, '').length < 1)
            mailEmptyArr = _arrMailEmpty(inputNode)
            chekboxEmptyInputArr = _arrCheckboxEmpty(inputNode).filter((x) => x.checked != true)
            fileInputArr = _arrFileEmpty(inputNode)
            passwordInputArr = _arrPasswordEmpty(inputNode)

            inputEmptyArr.forEach((el) => {
                el.parentElement.classList.add('input-error')
                _creatAtention(el.parentElement, el, 'data-empty')
            })

            passwordInputArr.forEach((el) => {
                el.parentElement.classList.add('input-error')
                _creatAtention(el.parentElement, el, 'data-empty')
            })

            chekboxEmptyInputArr.forEach((el) => {
                el.parentElement.classList.add('input-error')
            })

            fileInputArr.forEach((el) => {
                el.parentElement.classList.add('input-error')
            })
        }
    }

    forAjax()
}
