{include file="header.tpl" image=true title=$article.title keywords=$article.keywords description=$article.description}

<main class="main">

    <div class="flex:col">
        <div class="flex:col-max">

            {include file="modules/breadcrumbs.tpl"}

        </div>
    </div>

    <section class="flex:col pad-t-50 pad-b-50 bg-white">
        <div class="flex:col-max-1100">

            <div class="text-tmp title-44 time-center title-center">
                <time>{$article.publishedOn|date_format:'%d.%m.%Y'}</time>

                <h1>{$article.title}</h1>

                <img src="{$article.image->original}" alt="">

                {$article.content nofilter}
            </div>

        </div>
    </section>
    {fetch_section assign=othernews section=13}{if $othernews.status eq 'visible'}
    <section class="flex:col pad-t-50 pad-b-100 bg-white">
        <div class="flex:col-max">

            <div class="grid:fr-1 g-gap-50">

                <div class="head">

                    <div class="head__info">
                        <div class="text-tmp title-44 title-line">
                            <h2>Другие новости</h2>
                        </div>
                    </div>

                </div>

                <div class="grid:fr-4 g-gap-20 max">
                {fetch_articles limit=4 assign=news image=true section=$othernews.sectionId typeContent="news"}
                {if !empty($news)}
                    {foreach from=$news item=new}
                    <a class="news-card" href="{$new.url}">

                        <div class="news-card__img">
                            <img src="{$new.image->original}" alt="{$new.title nofilter}">
                        </div>

                        <div class="news-card__info">

                            <time>{$new.publishedOn|date_format:'%d.%m.%Y'}</time>

                            <div class="text-tmp title-16">
                                <h3>{$new.title}</h3>
                            </div>

                            <div class="btn-more accent-theme">
                                Подробнее

                                <svg fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <use xlink:href="images/sprites/sprite.svg#arrow-right-long"></use>
                                </svg>
                            </div>

                        </div>

                    </a>
            {/foreach}
        {/if}
                </div>

            </div>

        </div>
    </section>
{/if}
</main>

{include file="footer.tpl"}