{include file="header.tpl" title=$article.title keywords=$article.keywords description=$article.description}

<main class="main">
    <div class="flex:col">
        <div class="flex:col-max">

            {include file="modules/breadcrumbs.tpl"}

        </div>
    </div>

    <section class="flex:col pad-t-50 pad-b-50 bg-white">
        <div class="flex:col-max">

            <div class="both max">

                <div class="both__item">

                    <div class="text-tmp title-24 list-check list-bg mar-b-30">
                        <h1>{$article.title}</h1>

                        {$article.content nofilter}
                    </div>
                </div>

                <div class="both__item">
                    <div class="text-tmp">
                        <img src="{$article.image->original}" alt="">
                    </div>
                </div>

            </div>

        </div>
    </section>
    {fetch_section assign=otherProject section=11}{if $otherProject.status eq 'visible'}
    <section class="flex:col pad-t-50 pad-b-100 bg-white">
        <div class="flex:col-max">

            <div class="grid:fr-1 g-gap-50">

                <div class="head">

                    <div class="head__info">
                        <div class="text-tmp title-44 title-line">
                            <h2>Другие проекты</h2>
                        </div>
                    </div>

                </div>

                <div class="grid:fr-3 g-gap-20 full">
                    {fetch_articles limit=4 assign=other image=true section=$otherProject.sectionId}
                    {if !empty($other)}
                    {foreach from=$other item=otherContent}
                    <a class="prj-card" href="{$otherContent.url}">

                        <div class="prj-card__img">
                            <img src="{$otherContent.image->original}" alt="{$otherContent.title nofilter}">
                        </div>

                        <div class="prj-card__info">
                            <div class="text-tmp title-24 color-white">
                                <h3>{$otherContent.title}</h3>
                            </div>

                            <div class="btn-more">
                                Подробнее

                                <svg fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <use xlink:href="{$ASSETS_URL}/images/sprites/sprite.svg#arrow-right-long"></use>
                                </svg>
                            </div>
                        </div>

                    </a>
                    {/foreach}
                    {/if}


                </div>

            </div>

        </div>
    </section>
    {/if}
</main>

{include file="footer.tpl"}