{include file="header.tpl" title=$article.title keywords=$article.keywords description=$article.description}

<main class="main">
    <div class="flex:col">
        <div class="flex:col-max">

            {include file="modules/breadcrumbs.tpl"}

        </div>
    </div>

    <section class="flex:col pad-t-50 pad-b-100 bg-white">
        <div class="flex:col-max">

            <div class="grid:fr-1 g-gap-50">

                <div class="head">

                    <div class="head__info">
                        <div class="text-tmp title-44 txt-24 title-line txt-tt-up txt-fw-700 ff-f">
                            <h1>Вакансии</h1>
                        </div>
                    </div>

                </div>

                <div class="vacancy">
                                    {fetch_section assign=otherjobs section=15}{if $otherjobs.status eq 'visible'}
                    <aside class="grid:fr-1 g-gap-20 vacancy__aside">

                        <div class="head">

                            <div class="head__info">
                                <div class="text-tmp title-24">
                                    <h2>Другие вакансии</h2>
                                </div>
                            </div>

                        </div>

                        <div class="grid:fr-1 g-gap-20 vacancy__aside-inner">
                            {fetch_articles limit=4 assign=jobs image=true section=$otherjobs.sectionId}
                            {if !empty($jobs)}
                                {foreach from=$jobs item=job}
                            <a class="vacancy-card" href="{$job.url}">

                                <div class="vacancy-card__info">
                                    <div class="text-tmp title-24">
                                        <h2>{$job.title}</h2>
                                    </div>

                                    <ul>
                                        <li>
                                            <svg fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <use xlink:href="{$ASSETS_URL}/images/sprites/sprite.svg#location"></use>
                                            </svg>
                                            {$job.summary}
                                        </li>
                                        <li>
                                            <svg fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <use xlink:href="{$ASSETS_URL}/images/sprites/sprite.svg#clock"></use>
                                            </svg>
                                            {$job.alias}
                                        </li>
                                    </ul>
                                </div>

                                <div class="btn-more accent-theme">
                                    Подробнее

                                    <svg fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <use xlink:href="{$ASSETS_URL}/images/sprites/sprite.svg#arrow-right-long"></use>
                                    </svg>
                                </div>

                            </a>
                            {/foreach}
                            {/if}
                        </div>

                    </aside>
                {/if}           
                    <div class="vacancy__content">

                        <div class="vacancy__content-head">
                            <div class="text-tmp title-24">
                                <h2>{$article.title}</h2>
                            </div>

                            <ul>
                                <li>
                                    <svg fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <use xlink:href="{$ASSETS_URL}/images/sprites/sprite.svg#location"></use>
                                    </svg>
                                    {$article.summary}
                                </li>
                                <li>
                                    <svg fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <use xlink:href="{$ASSETS_URL}/images/sprites/sprite.svg#clock"></use>
                                    </svg>
                                    {$article.alias}
                                </li>
                            </ul>
                        </div>

                        <div class="text-tmp title-24">
                            {$article.content nofilter}
                        </div>

                        {include file="form/resume-form.tpl"}

                    </div>

                </div>

            </div>

        </div>
    </section>

</main>

{include file="footer.tpl"}