<!DOCTYPE html>
<html lang="{$config.website_language}">

<head>
    {include file="modules/meta.tpl"}
    {include file="modules/link.tpl"}

</head>

<body>
    <header class="header">
        <div class="flex:col-max">

            <div class="header__inner">

            {logo classLink="logo header__logo"}

                <nav class="header__nav">
                <ul>
                {fetch_sections assign=headerMenus status="visible" topMenu=1 level=1}
                {foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
                    <li>
                        {fetch_sections assign=headerSubMenus from=$headerMenu.sectionId status="visible" topMenu=1 level=2}

                        <a class="header__nav {if isset($section.sectionId) && $headerMenu.sectionId eq $section.sectionId}active{/if}" href="{$SITE_URL}{$headerMenu.url}">{$headerMenu.name}
                            {if !empty($headerSubMenus)}{include file="icon/svg.tpl" svgId="arrowBot" fill=""}{/if}</a>
                        {if !empty($headerSubMenus)}
                            <ul>
                                {foreach item=headerSubMenu from=$headerSubMenus name=headerSubMenus key=$key}
                                    <li><a href="{$SITE_URL}{$headerSubMenu.url}">{$headerSubMenu.name}</a></li>
                                {/foreach}
                            </ul>
                        {/if}

                    </li>
                {/foreach}
            </ul>
                </nav>

                <div class="header__lang">
                    <ul>
                        <li>
                            <button>
                                <img src="{$ASSETS_URL}/images/icons/lang/ru.png" alt="">

                                Ру

                                <svg fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <use xlink:href="{$ASSETS_URL}/images/sprites/sprite.svg#arrow-bot"></use>
                                </svg>

                            </button>

                            <ul>
                                <li>
                                    <a href="{$GLOBAL_URL}/uz">
                                        <img src="{$ASSETS_URL}/images/icons/lang/uz.png" alt="">

                                        Uz
                                    </a>
                                </li>

                                <li>
                                    <a href="{$GLOBAL_URL}/en">
                                        <img src="{$ASSETS_URL}/images/icons/lang/en.png" alt="">

                                        En
                                    </a>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </div>

                <button class="header__burger call-menu-btn_js">
                    <span class="burger-btn burger-btn_cross">
                        <span class="burger-btn__item"></span>
                    </span>
                </button>

            </div>

        </div>

        <div class="header-mob header-mob_js">
            <div class="header-mob__inner">

                  {logo classLink="logo header-mob__logo"}
                <div class="header-mob__lang">
                    <ul>
                        <li>
                            <button>
                                <img src="{$ASSETS_URL}/images/icons/lang/ru.png" alt="">

                                Ру
                            </button>
                        </li>

                        <li>
                            <a href="{$GLOBAL_URL}/uz">
                                <img src="{$ASSETS_URL}/images/icons/lang/uz.png" alt="">

                                Uz
                            </a>
                        </li>

                        <li>
                            <a href="{$GLOBAL_URL}/en">
                                <img src="{$ASSETS_URL}/images/icons/lang/en.png" alt="">

                                En
                            </a>
                        </li>
                    </ul>
                </div>

                <nav class="header-mob__nav">
                <ul>
                {fetch_sections assign=headerMenus status="visible" topMenu=1 level=1}
                {foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
                    <li>
                        {fetch_sections assign=headerSubMenus from=$headerMenu.sectionId status="visible" topMenu=1 level=2}

                        <a class="{if isset($section.sectionId) && $headerMenu.sectionId eq $section.sectionId}active{/if}"
                            href="{$SITE_URL}{$headerMenu.url}">{$headerMenu.name}
                            {if !empty($headerSubMenus)}{include file="icon/svg.tpl" svgId="arrowBot" fill=""}{/if}</a>
                        {if !empty($headerSubMenus)}
                            <ul>
                                {foreach item=headerSubMenu from=$headerSubMenus name=headerSubMenus key=$key}
                                    <li><a href="{$SITE_URL}{$headerSubMenu.url}">{$headerSubMenu.name}</a></li>
                                {/foreach}
                            </ul>
                        {/if}

                    </li>
                {/foreach}
                </ul>
                </nav>

                <div class="header-mob__contacts">
                    <ul>
                        <li>{$config.address nofilter}</li>
                        {assign var=phones value=", "|explode:$config.phone}
                        {foreach from=$phones item=phone}
                            <li><a href="tel:{$phone|strip_phone}">{$phone|format_phone} </a></li>
                        {/foreach}
                        <li><a href="mailto:{$config.email}">{$config.email}</a></li>
                    </ul>
                </div>

                <div class="social">
                    <ul>
                        <li>
                            {include file="modules/block-socials.tpl" class="social"}   
                        </li>
                    </ul>
                </div>
            </div>
        </div>
</header>