<script>
{literal}
 var App = function() {

     const appUrl = "{/literal}{$GLOBAL_URL}{literal}/ajax-app";
     var _sortingAction = function () {
         $('.discount_check').on('change', function() {
             $('form.discount').submit();
         });

	     // классы
	     $(document).on('click', '.checkbox_class', function(){
             var checkboxes = [];
             $('input.checkbox_class:checkbox:checked').each(function() {
                 checkboxes.push(this.value);
             });
             console.log(checkboxes.join('/'));
             $('.car_classes').val(checkboxes.join('/'));

             var selector = '.catalog__filter-aside-choise.car_mark_list';

             $.ajax({ url: appUrl, type: 'POST', dataType: 'json', data: { action: 'classes', classes: checkboxes.join('/') } }).done(function(response) {
                 $(selector).replaceWith('<div class="catalog__filter-aside-choise car_mark_list">' + response.data + '</div>');
                 $('.model_list').replaceWith('<select class="model_list" name="md">' + response.models + '</select>');
             }).fail(function(error) {
                 console.log(error);
             });
         })

	     // марки
         $(document).on('click', '.checkbox_mark', function(){
             var checkboxes = [];
             $('input.checkbox_mark:checkbox:checked').each(function() {
                 checkboxes.push(this.value);
             });
             console.log(checkboxes.join('/'));
             $('.car_marks').val(checkboxes.join('/'));
             var selector = '.model_list';
             $.ajax({ url: appUrl, type: 'POST', dataType: 'json', data: { action: 'models', classes: $('.car_classes').val(), marks: checkboxes.join('/') } }).done(function(response) {
                 $('.model_list').replaceWith('<select class="model_list" name="md">' + response.data + '</select>');
             }).fail(function(error) {
                 console.log(error);
             });
         })




         $('.stock_check').on('change', function() {
             var $this = $(this);
	         console.log($(this).val())
             $.ajax({
	             url: appUrl,
	             type: 'POST',
	             dataType: 'json',
	             data: { action: 'stock', stock: $(this).val() },
             }).done(function(response) {
                 window.location.reload();
             }).fail(function(error) {
	             console.log(error);
             });
         })

         $('.discount_check').on('change', function() {
             $.ajax({
                 url: appUrl,
                 type: 'POST',
                 dataType: 'json',
                 data: { action: 'discount', discount: $(this).val() },
             }).done(function(response) {
                 window.location.reload();
             }).fail(function(error) {
                 console.log(error);
             });
         })
     }

     var _orderAction = function () {

         $(document).on('click', '.order_button', function (e) {
             e.preventDefault();
             var orderForm = $("form#order"), orderFormButton = $(".order_button");

             $.ajax({
                 type: "POST",
                 url: orderForm.attr('action'),
                 data: orderForm.serialize(),
                 beforeSend:function(){
                     // orderFormButton.text('Отправляется......').attr('disabled', true);
                 },
                 success: function(response){
                     console.log(response);
                     $('.notification').fadeIn().text(response.message).css('color', response.color);
                     if (response.status === 200) {
                         if (response.form) {
                             $('.payment_form').replaceWith('<div class="payment_form">' + response.form + '</div>')
                         }
                     } else {
                         if (response.errors) {
                             response.errors.forEach(function(item) {
                                 $('#'+item).addClass('input-error');
                                 // console.log(item)
                             });
                             $('html, body').animate({
                                 scrollTop: ($('.input-error').first().offset().top - 120)
                             }, 400);

                         }
                     }
                 },
                 error : function(request) {
                     console.log(request.responseText);
                 }
             });


         })
     }


     // Избранные
     var _favoriteAction = function () {
         $(document).on('click', '.favorite_btn', function(e){
             e.preventDefault();
             var $this = $(this);

             $.ajax({
                 url: appUrl,
                 type: 'POST',
                 dataType: 'json',
                 data: { action: 'favorite', id: $this.data('id') },
             })
                 .done(function(response) {
                     $this.toggleClass('active');
                     $('.favor-log__link-num').text(response.count);
                 })
                 .fail(function(error) {
                     console.log(error);
                 })
                 .always(function() {
                     // HideLoading();
                 });
         })


         $(document).on('click', '.favorite_btn_delete', function(e){
             e.preventDefault();
             var $this = $(this);
             ShowLoading('.grid-container-4');
             $.ajax({ url: appUrl, type: 'POST', dataType: 'json', data: {action: 'favorite', id: $this.data('id') } })
	             .done(function(response) {
                     $('#favorite_item_'+$this.data('id')).remove();
                     $('.favor-log__link-num').text(response.count);
                 })
                 .fail(function(error) {
                     console.log(error);
                 })
                 .always(function() {
                     HideLoading();
                 });
         })
    };

     var ShowLoading = function (selectorCont) {
         const catalogContainer = document.querySelector(selectorCont)
         var createPreloader = document.createElement('div')
         var createRound = document.createElement('div')

         if (catalogContainer) {
             createPreloader.classList.add('product-preloader')
             createRound.classList.add('product-preloader__round')
             createPreloader.insertAdjacentElement('beforeend', createRound)
             catalogContainer.insertAdjacentElement('beforeend', createPreloader)

             // тут я принудительно удаляю через полторы секунды, так как увидел что на избранном при удалении не отрабатывает удаление
             setTimeout(() => {
                 const preloader = document.querySelector('.product-preloader')
                 if (preloader) {
                     preloader.remove()
                 }
             }, 1500)
         }
     }

     var HideLoading = function () {
         const preloader = document.querySelector('.product-preloader')
         if (preloader) {
             preloader.remove()
         }
     }


    // Возврат объектов, назначенных модулю
     return {
        init: function() {
            _sortingAction();
            _orderAction();
            _favoriteAction();
        }
    } 

}(); 

// Инициализировать модуль
 document.addEventListener('DOMContentLoaded', function() {
    App.init();
});  
{/literal}
</script>