{include file="header.tpl" title=$section.meta_title keywords=$section.keywords description=$section.description}
{fetch_articles perPage=8 assign=news image=true section=$section.sectionId typeContent="news" assignPagination=pagination page=$page path=$section.path seFriendly=true sectionInfo=true}

<main class="main">

    <div class="flex:col">
        <div class="flex:col-max">

            {include file="modules/breadcrumbs.tpl"}

        </div>
    </div>

    <section class="flex:col pad-t-50 pad-b-100 bg-white">
        <div class="flex:col-max">

            <div class="grid:fr-1 g-gap-50">

                <div class="head">

                    <div class="head__info">
                        <div class="text-tmp title-44 txt-24 title-line txt-tt-up txt-fw-700 ff-f">
                            <h1>{$section.name}</h1>
                        </div>
                    </div>

                </div>

                <div class="grid:fr-4 g-gap-20 max ">
                {foreach from=$news item=new}
                    <a class="news-card" href="{$new.url}">

                        <div class="news-card__img">
                            <img src="{$new.image->original}" alt="{$new.title nofilter}">
                        </div>

                        <div class="news-card__info">

                            <time>{$new.publishedOn|date_format:$config.date_format_custom}</time>

                            <div class="text-tmp title-16">
                                <h3>{$new.title}</h3>
                            </div>

                            <div class="btn-more accent-theme">
                                Подробнее

                                <svg fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <use xlink:href="images/sprites/sprite.svg#arrow-right-long"></use>
                                </svg>
                            </div>

                        </div>

                    </a>
                {/foreach}
                </div>
{include file="modules/pagination.tpl"}
            </div>

        </div>
    </section>

</main>

{include file="footer.tpl"}