<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\Helpers;
use Mnv\Core\AdminMnv;

use Mnv\Core\Managers;
use Mnv\Models\BannerGroups;

/**
 * Class BannerGroupAdmin
 * @package Mnv\Admin\Controllers
 */
class BannerGroupAdmin extends AdminMnv
{

	public function fetch()
    {
        $groupBanners = new BannerGroups();

        $this->smarty->assign('activeItem','bannergroups');
        $this->smarty->assign('title', 'Группы баннеров');

        $this->smarty->assign('statuses', array_slice(lang('sliders:statuses'), 1));
        $this->smarty->assign('sections', Helpers::init()->getAllSectionOptions());

        $groupBanners->group   = getRequestVar('group', '',  true);
        $groupBanners->groupId = (int) getRequestVar('id', '');

        if ($this->action == 'add' || $this->action == 'edit') {

            $groupBanners->edit();

        } else if ($this->action == 'save' || $this->action == 'apply') {

            if (empty($groupBanners->group['name'])) {
                $this->errors['name'] = true;
            }
            if (!empty($groupBanners->group['pages'])) {
                $groupBanners->group['pages'] = implode(',', $groupBanners->group['pages']);
            } else {
                $this->errors['sectionId'] = true;
            }

            if (empty($this->errors)) {
                if (empty($groupBanners->groupId)) {
                    if ($groupBanners->add($groupBanners->group)) {
                        $this->messages['saved'] = true;
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                    if (empty($this->errors) && $this->action === 'apply') {
                        redirect($this->adminUrl . "/bannergroup?" . $this->buildQueryString([
                                'action'=> 'edit',
                                'id'    => $groupBanners->groupId,
                                'page'  => $this->page
                            ]));
                    }
                } else {
                    if ($groupBanners->update($groupBanners->group)) {
                        $this->messages['saved'] = true;
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                }
                $groupBanners->edit();

                if (empty($this->errors) && $this->action == 'save') {
                    redirect($this->adminUrl . "/bannergroups?" . $this->buildQueryString(['page' => $this->page]));
                }
            }
        }



        $this->smarty->assign('group',  $groupBanners->group);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('bannergroups')) {
            return $this->smarty->fetch('banner-group.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }


}