<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}


use Mnv\Core\AdminMnv;
use Mnv\Core\Managers;
use Mnv\Models\Banners;

/**
 * Class BannersAdmin
 * @package Mnv\Admin\Controllers
 */
class BannersAdmin extends AdminMnv
{
    private $bannerId;

    /**
     * Вывод всех банеров
     * @return string
     * @throws \SmartyException
     */
    public function fetch()
    {

        $banners = new Banners();

        $this->smarty->assign('activeItem','banners');
        $this->smarty->assign('title', lang('banners:sectionName'));

        $this->action   = getRequestVar('action','');
        $this->bannerId = getRequestVar('id','');

        switch ($this->action) {
            case 'remove':
                if ($banners->remove($this->bannerId)) {
                    echo "removeElement($this->bannerId, 'banner');\r\n";
                    echo "deleteMessage();\r\n"; // TODO не забыть удалить в script.js
                    exit;
                }
                break;
        }

        $bannersArr = $banners->getAllBanners();
        $this->smarty->assign('adBanners', $bannersArr);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('banners')) {
            return $this->smarty->fetch('banners.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }
}


