<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}


use Mnv\Core\Managers;
use Mnv\Core\Test\Logger;
use Mnv\Models\Brands;
use Mnv\Models\Countries;

/**
 * Class BrandAdmin
 * @package Mnv\Admin\Controllers
 */
class BrandAdmin extends Brands
{

    protected $imageId;

    public function fetch()
    {
        $countries = new Countries();
        $this->smarty->assign('title', lang('brands:title'));
        $this->smarty->assign('activeItem', 'brands');
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));
        $this->smarty->assign('countryList', $countries->getSelectCountries());

        /** получение параметров */
        $this->brandId   = (int) getRequestVar('id', '');
        $this->brand     = getRequestVar('brand', '', true);

        /** работа с галереей */
        $image    = getRequestVar('image', '', true);
        $gallery  = getRequestVar('gallery', '', true);
        $imageIds = getRequestVar('imageIds', '', true);
        $imageId  = (int) getRequestVar('imageId', '');
        $picture  = getRequestVar('picture', '', true);

        if ( $this->action == 'add' || $this->action == 'edit' ) {
            $this->edit();
        }
        /** сохранение данных */
        else if ( $this->action == 'save'|| $this->action == 'apply') {

            /** проверка полей */
            if (empty($this->brand['name'])) $this->errors['name'] = true;
            /** проверка fileName на совпадение / если пустой то fileName пропишется от последнего ID из таблицы + 1 */
            if ($fileName = $this->isFileName($this->brand['fileName'])) {
                if ($fileName == $this->brand['fileName']) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $this->brand['fileName'] = $fileName;
                }
            }

            /** основная картинка */
            $images['fileId'] = !empty($image) ? $image['fileId'] : null;
            /** включить / отключить галерею у данного контента */
            $this->brand['enableGallery'] = isset($this->brand['enableGallery']) ? 1 : 0;
            $images['gallery'] = !empty($gallery) ? $gallery : null;

            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {
                /** построение url из полученного url раздела/fileName статьи . расширение файла из настроек  (html / htm)  */
                $this->brand['url'] = SITE_URL.'/brands/'.$this->brand['fileName'];

                /** если пустой ID то создаем / если существует ID то редактируем */
                if (empty($this->brandId)) {
                    if ($this->add($this->brand, $images, $this->manager->userId)) {
                        $this->messages['saved'] = true;
                        Logger::init()->info("Добавлен новый бренд «" . $this->brand['name'] . "»", $this->manager)->save();

                        if (empty($this->errors) && $this->action === 'apply') {
                            redirect($this->adminUrl . "/brand?" . $this->buildQueryString([
                                'action'=> 'edit',
                                'id'    => $this->brandId,
                                'page'  => $this->page
                            ]));
                        }
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                } else {
                    $this->update($this->brand, $images, $this->manager->userId);
                    $this->messages['saved'] = true;
                    Logger::init()->info("Бренд «" . $this->brand['name'] . "» отредактирован", $this->manager)->save();
                }
            } else {
                $this->smarty->assign('action', 'edit');
                $this->edit();
            }

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->adminUrl . "/brands?" . $this->buildQueryString(['page' => $this->page]));
            }

        }
        /** удаление основной картинки */
        else if ($this->action == 'deleteImage') {

            $result = $this->deleteImage($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingImage'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingImageError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** редактирование / добавление описания картинки */
        else if ($this->action == 'editPictureInfo') {

            if ($result = $this->editPictureInfo($imageId, $picture)) {
                $response = array('status' => 200, 'title' => $result->title, 'alias' => $result->alias, 'description' => $result->description, 'link' => $result->link, 'position' => $result->position);
            } else {
                $response = array('status' => 400, 'title' => '', 'alias' => '', 'description' => '', 'link' => '', 'position' => '');
            }
            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            exit();
        }
        /** сортировка картинок в галереи */
        else if ($this->action == 'sortPictures') {

            $this->sortPictures($imageIds);
        }
        /** удаление из галереи */
        else if ($this->action == 'deletePicture') {
            $result = $this->deletePicture($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingImage'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingImageError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        $this->smarty->assign('brand', $this->brand);


        if (Managers::init()->permissions('brands')) {
            return $this->smarty->fetch('brand.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }

}
