<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\Managers;
use Mnv\Core\Test\Logger;
use Mnv\Models\Brands;

/**
 * Class BrandsAdmin
 * @package Mnv\Admin\Controllers
 */
class BrandsAdmin extends Brands
{

    public function fetch()
    {

        $this->smarty->assign('title', lang('brands:title'));
        $this->smarty->assign('activeItem', 'brands');

        $this->brandId = (int) getRequestVar('id', '');

         if ($this->action == 'remove') {

            if ($this->remove()) {
                Logger::init()->info("Бранд с «ID-" . $this->brandId . "» удален.", $this->manager)->save();
                response()->make("deleteSuccess('" . $this->brandId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }

        } else if ($this->action == 'approve') {

            if ($this->approve()) {
                response()->make("document.getElementById('status-$this->brandId ').innerHTML = 'Включено';", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }

        }
        // не делал еще
//        else if ($this->action == 'reorder') {
//
//            $ids = array_values($this->brandIds);
//            sort($this->brandIds);
//            //$this->brandIds = array_reverse($this->brandIds);
//            $this->reorderBrand($ids, $this->brandIds);
//
//        }
        else if ($this->action == 'status') {

            if ($result = $this->status()) {
                response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();
            }
            exit();

        } else {

            /** получение всех статей */
            $this->listBrand();
            if (!is_null($this->brands)) {
                foreach ($this->brands as $brandId => $brand) {
                    $this->brands[$brandId]['statusName']  = lang('general:statuses:' . $brand['status']);
                    $this->brands[$brandId]['image']       = $this->getFile($brand['brandId']);
                }
            }


            /** pagination */
            $pages = getPageNums($this->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalArticles', $this->total);
            $this->smarty->assign('brands', $this->brands);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('page', $this->page);

        }

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('brands')) {
            return $this->smarty->fetch('brands.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }

}