<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers;
use Mnv\Models\Comments;

/**
 * Class CommentsAdmin
 * @package Mnv\Admin\Controllers
 */
class CommentsAdmin extends AdminMnv
{


    protected $comment;
    protected $commentId;
    protected $bulk;

    public $order;
    public $where = array();
    public $join = array();

    /**
     * @return string
     * @throws \SmartyException
     */
    public function fetch()
    {
        $comments = new Comments();
        $dateSelector = new StatsDateSelector(false, 'commentDateSelector');

        $this->smarty->assign('activeItem','comments');
        $this->smarty->assign('title', lang('comments:title'));
        /* statuses */
        $this->smarty->assign('statuses', lang('comments:statuses'));

        $this->comment = getRequestVar('comment','', true);
        $this->commentId = (int) getRequestVar('id','');
        $this->query   = getRequestVar('query','');
        $this->status  = getRequestVar('status','');
        $this->bulk    = getRequestVar('bulk','');


        if (($this->action === 'bulk') && $comments->bulk($this->bulk)) {
            $this->messages['bulk_save'] = true;
        }

        /** фильтровать контент */
        $filter = array_filter([
            'dateStart'     => $dateSelector->dateStart,
            'dateEnd'       => $dateSelector->dateEnd,
            'query'         => $this->query,
            'status'        => $this->status,
        ]);

        /* показывать комментарии только из разрешенных разделов */
        $comments->getAllComments($filter);

        $comments->countComments($filter);
        $pages = getPageNums($comments->total, $this->page, $this->limit, 0, 4, 4, 0);
        $this->smarty->assign('totalComments', $comments->total);
        $this->smarty->assign('comments', $comments->comments);
        $this->smarty->assign('pageNums', $pages);


        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('comments')) {
            return $this->smarty->fetch('comments.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }

}