<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\Helpers;
use Mnv\Core\Managers;
use Mnv\Core\Test\Logger;
use Mnv\Models\Contents\Content;

use Mnv\Models\Contents\Exceptions\NoContentException;
use Mnv\Models\Contents\Exceptions\EmptyArticleIdException;
use Mnv\Models\Contents\Exceptions\ContentNotDeletedException;
use Mnv\Models\Contents\Exceptions\NotContentApproveException;

/**
 * Class ContentsAdmin
 * @package Mnv\Admin\Controllers
 */
class ContentsAdmin extends Content
{

    public function fetch()
    {
        global $SECTIONS;

        $dateSelector = new StatsDateSelector(false, 'contentDateSelector');

        /** модуль */
        $module = getRequestVar('mod','');
        /** title */
        $this->smarty->assign('title', lang($module .':title'));
        /** activeItem */
        $this->smarty->assign('activeItem', $module);
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $module);
        /** type content */
        $this->typeContent   = getRequestVar('typeContent', $module);

        /** получение ID для редактирования / удаления / изменение статуса / удаление и обновление основной картинки */
        $this->articleId    = (int) getRequestVar('id', '');
        $contentIds             = getRequestVar('articleIds', '', true);
        $group_action           = getRequestVar('group_action');

        /** получение разделов по типу контента */
        $sections = Helpers::init()->getSectionContent(0, $this->typeContent);

        /** действия */
        if ($this->action === 'remove') {
            try {
                $this->remove();
                Logger::init()->info("Контент «" . $this->content['title'] . "» удален.", $this->manager)->save();
                response()->make("deleteSuccess('" . $this->articleId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (ContentNotDeletedException $e) { /** ошибка при удаление контента */
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (EmptyArticleIdException | NoContentException $e) { /** контент не найден или пустой ID */
                response()->make("notFound();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
        }
        else if ($this->action === 'approve') {

            try {
                $this->approve();
                response()->make("approveSuccess('" . $this->articleId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (NotContentApproveException $e) { /** ошибка при одобрение контента */
                response()->make("approveError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (EmptyArticleIdException | NoContentException $e) { /** контент не найден или пустой ID */
                response()->make("notFound();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit();

        }
        /** изменение статуса */
        else if ($this->action === 'status') {

            try {
                $this->status();
                response()->json($this->result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            } catch (NotContentApproveException $e) { /** ошибка при изменение статуса контента */
                response()->make("statusError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (EmptyArticleIdException | NoContentException $e) { /** контент не найден или пустой ID */
                response()->make("notFound();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit();
        }
        /** Групповые действия  */
        else if ($this->action === 'group') {
            if (!empty($group_action)) {
                if (!empty($contentIds)) {
                    foreach ($contentIds as $contentId) {
                        $this->articleId = $contentId;
                        $this->group($group_action);
                    }
                    $response = array('status' => 200, 'message' => 'Успешно выполнено', 'type' => 'success');
                } else {
                    $response =  array('status' => 500, 'message' => 'Необходимо выбрать контент', 'type' => 'error');
                }
            } else {
                $response =  array('status' => 500, 'message' => 'Необходимо выбрать действие', 'type' => 'error');
            }

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

        }
        else {

            /** фильтровать контента */
            $this->filter = array_filter([
                'dateStart'     => $dateSelector->dateStart,
                'dateEnd'       => $dateSelector->dateEnd,
            ]);

            /** получение всех статей */
            $this->listContent('publishedOn DESC');
            if (!is_null($this->contents)) {
                foreach ($this->contents as $articleId => $content) {
                    $this->contents[$articleId]['statusName']  = lang('general:statuses:' . $content['status']);
                    $this->contents[$articleId]['publishedOn'] = langDate(adjustTime($content['publishedOn'], false, 'd.m.Y'));
                    $this->contents[$articleId]['image']       = $this->getFile($content['articleId']);
                    $this->contents[$articleId]['section']     = array();
                    if (isset($SECTIONS[$content['sectionId']])) {
                        $this->contents[$articleId]['section'] = $SECTIONS[$content['sectionId']];
                    }
                }
            }

            /** pagination */
            $pages = getPageNums($this->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalArticles', $this->total);
            $this->smarty->assign('articles', $this->contents);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('sections', $sections);
            $this->smarty->assign('page', $this->page);
        }

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }
        
        /** Права доступа к данному шаблону */
        if (Managers::init()->permissions($module)) {
            return $this->smarty->fetch('articles.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}