<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\Managers;
use Mnv\Models\FAQ;

/**
 * Class FAQAdmin
 * @package Mnv\Admin\Controllers
 */
class FAQAdmin extends FAQ
{

	public function fetch()
    {

        $this->smarty->assign('activeItem','faqs');
        $this->smarty->assign('title', 'FAQ');

        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));

        $this->faq   = getRequestVar('faq', '', true);
        $this->faqId = getRequestVar('id', '');

        if ($this->action == 'add' || $this->action == 'edit') {
            $this->edit();
        } else if ($this->action == 'save' || $this->action == 'apply') {

            if (empty($this->faq['question'])) $this->errors['question'] = true;

            if (empty($this->errors)) {
                if (empty($this->faqId)) {
                    if ($this->add($this->faq)) {
                        $this->messages['saved'] = true;
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                    if (empty($this->errors) && $this->action == 'apply') {
                        redirect($this->adminUrl . "/faq?" . $this->buildQueryString([
                                'action'=> 'edit',
                                'id'    => $this->faqId
                            ]));

                    }
                } else if ($this->update($this->faq)) {
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }

                if (empty($this->errors) && $this->action == 'save') {
                    redirect($this->adminUrl . "/faqs");
                }
            }
            $this->edit();
        }

        $this->smarty->assign('faq', $this->faq);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('faqs')) {
            return $this->smarty->fetch('faq.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }


}