<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\Helpers;
use Mnv\Core\AdminMnv;
use Mnv\Core\Managers;
use Mnv\Models\Features;

/**
 * Class FeatureAdmin
 * @package Mnv\Admin\Controllers
 */
class FeatureAdmin extends AdminMnv
{

    public function fetch()
    {
        $feature = new Features();

        $this->smarty->assign('activeItem','features');
        $this->smarty->assign('title', 'Свойства товара');
        /* statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));
        $this->smarty->assign('filters', array(0 => 'Нет', 1 => 'Да'));
        $this->smarty->assign('sections', Helpers::init()->getSectionContent(0, 'products'));

        /** получение ID для удаления / изменение  */
        $feature->featureId     = (int) getRequestVar('id', '');
        $feature->feature       = getRequestVar('feature', '', true);


        if ($this->action == 'add' || $this->action == 'edit') {
           $feature->edit();

        } else if ($this->action == 'save' || $this->action == 'apply') {

            /** проверка полей */
            if (empty($feature->feature['name'])) {
                $this->errors['name'] = true;
            }
            if (empty($feature->feature['fileName'])) {
                $this->errors['fileName'] = true;
            }
            $feature->feature['isFilter'] = $feature->feature['isFilter'] ?? 0;
            /** проверка доступных разделов для статей */
            if (empty($feature->feature['sectionIds'])) {
                $this->errors['sectionId'] = true;
            }


            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {

                $feature->feature['sectionIds'] = json_encode($feature->feature['sectionIds'], JSON_THROW_ON_ERROR | JSON_UNESCAPED_UNICODE);
                /** если пустой ID то создаем новую / если существует ID то редактируем */
                if (empty($feature->featureId)) {
                    if ($feature->add($feature->feature)) {
                        $this->messages['saved'] = true;
                    } else {
                        $this->errors['not_saved'] = true;
                    }

                    if (empty($this->errors) && $this->action === 'apply') {
                        redirect($this->adminUrl . "/feature?" . $this->buildQueryString([
                                'action'=> 'edit',
                                'id'    => $feature->featureId,
                                'page'  => $this->page
                            ]));
                    }
                } else {
                    $feature->update($feature->feature);
                    $this->messages['saved'] = true;
                }
            }


            $feature->edit();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->adminUrl . "/features?" . $this->buildQueryString(['page' => $this->page]));
            }
        }

        if (!empty($feature->feature['sectionIds'])) {
            $feature->feature['sectionIds'] = json_decode($feature->feature['sectionIds'], true);
        }

        $this->smarty->assign('feature', $feature->feature);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('features')) {
            return $this->smarty->fetch('feature.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }
}