<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers;

/**
 * Class GeoCountryAdmin
 * @package Mnv\Admin\Controllers
 */
class GeoCountryAdmin extends AdminMnv
{
    public function fetch()
    {
        $countries = new \Mnv\Models\Countries();

        $this->smarty->assign('activeItem', 'countries');
        $this->smarty->assign('title', 'Страны');
        /* statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));

        $countries->countryId = (int)getRequestVar('id', '');
        $countries->country = (object)getRequestVar('country', '', true);

        if ($this->action == 'add' || $this->action == 'edit') {
            $countries->edit();
        } else if ($this->action == 'save' || $this->action == 'apply') {

            if (empty($countries->country->name)) {
                $this->errors['name'] = true;
            }

            if (empty($this->errors)) {

                if (empty($countries->countryId)) {
                    $countries->add($countries->country);
                } else {
                    $countries->update($countries->country);
                }

                $this->messages['saved'] = true;
            }
            $countries->edit();

            if (empty($this->errors)) {
                redirect($this->adminUrl . "/countries");
            }

        }

        if (!($countries->country instanceof \stdClass)) $countries->country = (object)$countries->country;

        $this->smarty->assign('country', $countries->country);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        /** Права доступа к данному шаблону */
        if (Managers::init()->permissions('countries')) {
            return $this->smarty->fetch('geo.country.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }
}


