<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\Managers;
use Mnv\Models\Languages\Languages;
use Mnv\Core\Locale\Charset;
use Mnv\Core\Locale\LanguageSelection;

/**
 * Class LanguageAdmin
 * @package Mnv\Admin\Controllers
 */
class LanguageAdmin extends Languages
{

    public function fetch()
    {
        global $LANGUAGES;

        $this->smarty->assign('activeItem','languages');
        $this->smarty->assign('title', lang('languages:title'));

        $this->language   = getRequestVar('language', '', true);
        $this->languageId = (int) getRequestVar('id','');

        /** если не существует ни одной версии языка то первый добавленный делаем по умолчанию */
        if ($this->isMultiLang()) {
            $this->language['isDefault'] = 1;
            $multiLang['isDefault'] = true;
            $this->smarty->assign('multiLang', $multiLang);
        }

        /** добавление  */
        if ($this->action == 'add' || $this->action == 'edit') {
            $this->edit();
            if (count($LANGUAGES) > 0) {
                $this->smarty->assign('adminLangs', getLanguages());
            }
        }
        /** сохранение */
        else  if ($this->action == 'save') {

            if (empty($this->language['languageName'])) {
                $this->errors['languageName'] = true;
            }
            if (preg_match('/[^a-zA-Z]/', $this->language['languageName'])) {
                $this->errors['languageNameCharacters'] = true;
            }

            if (empty($this->languageId)) {
                /* check codename only for new languages */
                $this->language['codename'] = strtolower(trim($this->language['codename']));
                if (empty($this->language['codename'])) {
                    $this->errors['codename'] = true;
                }
                if ($codeName = $this->isCodeName($this->language['codename'])) {
                    if ($codeName == $this->language['codename']) {
                        $this->errors['codenameExists'] = true;
                    } else {
                        $this->language['codename'] = $codeName;
                    }
                }
                if (preg_match('/[^a-z]/', $this->language['codename'])) {
                    $this->errors['codenameCharacters'] = true;
                }
            }

            if (empty($this->errors)) {
                if (empty($this->languageId)) {
                    if ($this->add($this->language, $this->manager->userId)) {
                        $this->messages['saved'] = true;
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                } else {
                    if ($this->update($this->language, $this->manager->userId)) {
                        $this->messages['saved'] = true;
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                }

                if (empty($this->errors)) {
                    redirect($this->adminUrl . '/langs');
                }
            }
        }

        $this->smarty->assign('language', $this->language);
        $this->smarty->assign('languageOptions',    LanguageSelection::$languageOptions);
        $this->smarty->assign('languageCharsets',   Charset::$languageCharsets);
        $this->smarty->assign('charsetOptions',     Charset::$charsetOptions);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('langs')) {
            return $this->smarty->fetch('language.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }
}



