<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\Managers;
use Mnv\Models\Logs;

/**
 * Class LogsAdmin
 * @package Mnv\Admin\Controllers
 */
class LogsAdmin extends Logs
{

    public function fetch()
    {
        $dataLogs = array();
        $this->smarty->assign('activeItem','logs');
        $this->smarty->assign('title', 'Журнал событий');


        if ($this->action == 'clear') {
            $this->remove();
        }

        $this->getAllLog();
        foreach ($this->logs  as $data) {
            $data->date_log = langDate(adjustTime($data->date_log, false, 'd.m.Y H:i'));
		    $dataLogs[] = $data;
        }

        $pages = getPageNums($this->total, $this->page, $this->limit, 0, 4, 4, 0);
        $this->smarty->assign('totalLogs', $this->total);
        $this->smarty->assign('pageNums', $pages);
		$this->smarty->assign("datalog", $dataLogs);

        if (Managers::init()->permissions('logs')) {
            return $this->smarty->fetch('logs.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }

}

