<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\Managers;
use Mnv\Core\Menu;
use Mnv\Models\Users\UserGroups;

/**
 * Class ManagerGroupsAdmin
 * @package Mnv\Admin\Controllers
 */
class ManagerGroupsAdmin extends UserGroups
{

    /**
     * Вывод всех пользователей
     */
    public function fetch()
    {
        $access     = new Menu();

        $this->smarty->assign('activeItem', 'managergroups');
        $this->smarty->assign('title', "Группы пользователей");

        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1, 2));

        $this->groupId     = (int) getRequestVar('id','');
        $this->group       = getRequestVar('group','', true);
        $this->privileges  = getRequestVar('privileges','');

        $permission = $access->accessRights($this->manager);
        $this->smarty->assign('permission', $permission);

        if ($this->action == 'edit') {

            $this->edit();
            $this->smarty->assign('manager', $this->group);
        }

        /** сохрание жанных */
        else if ($this->action == 'save' || $this->action == 'apply') {

            /** groupName */
            if (empty($this->group['groupName'])) {
                $this->errors['name_empty'] = true;
            }
            if (empty($this->privileges)) {
                $this->errors['privileges_empty'] = true;
            }

            /** проверяем существование loginName */
            if ($fileName = $this->checkExistenceGroupName($this->group['groupName'])) {
                if ($fileName == $this->group['groupName']) {
                    $this->errors['name_exists'] = true;
                } else {
                    $this->group['groupName'] = $fileName;
                }
            }

            if (empty($this->errors)) {
                if (empty($this->groupId)) {
                    if ($this->add($this->group)) {
                        $this->messages['saved'] = true;
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                } else {
                    $this->update($this->group);
                   $this->messages['saved'] = true;
                }
            }

            if (empty($this->errors) && $this->action == 'apply') {
                redirect($this->adminUrl . "/managergroups?" . $this->buildQueryString([
                    'action'=> 'edit',
                    'id'    => $this->groupId
                ]));
            }

            $this->edit();
            $this->smarty->assign('action', 'edit');

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->adminUrl . "/managergroups");
            }

        }
        else if ($this->action == 'remove') {
            if ($this->remove()) {
                response()->make("deleteSuccess('" . $this->groupId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
        }
        else if ($this->action == 'status') {
            $result = $this->status();
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'])->send();

        }
        else {

            /** получение всех статей */
            $this->listGroup( $this->manager);
            if (!is_null($this->groups)) {
                foreach ($this->groups as $groupId => $group) {
                    $this->groups[$groupId]['statusName']  = lang('general:statuses:' . $group['status']);
                }
            }

            $this->smarty->assign('groups', $this->groups);
        }


        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('managergroups')) {
            return $this->smarty->fetch('manager-groups.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }


}
