<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers;
use Mnv\Models\Users\UserGroups;
use Mnv\Models\Users\UserFactory;
use Mnv\Models\Users\Exceptions\NoUserException;
use Mnv\Models\Users\Exceptions\EmptyUserIdException;
use Mnv\Models\Users\Exceptions\UserNotDeletedException;
use Mnv\Models\Users\Exceptions\CannotBeRemovedDeveloperException;
use Mnv\Models\Users\Exceptions\CannotBeRemovedAdministratorException;
use Mnv\Models\Users\UserTypes;

/**
 * Class ManagersAdmin
 * @package Mnv\Admin\Controllers
 */
class ManagersAdmin extends AdminMnv
{

    public function fetch()
    {
        $adminUser = UserFactory::adminUser();

        /** Заголовок, название подключаемого шаблона */
        $this->smarty->assign('activeItem', 'managers');
        $this->smarty->assign('title', lang('managers:title'));

        /** Получаемые параметры $_GET / $_POST */
        $adminUser->userId  = (int) getRequestVar('id','');


        if ($this->action == 'remove') {
            try {
                $adminUser->remove(UserTypes::ADMIN);
                response()->make("deleteSuccess('" . $adminUser->userId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (CannotBeRemovedDeveloperException $e) {
                response()->make("notDeleteDeveloper();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (CannotBeRemovedAdministratorException $e) {
                response()->make("notDeleteAdministrator();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (EmptyUserIdException | NoUserException $e) {
                response()->make("userNotFound();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } catch (UserNotDeletedException $e) {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit();
        }

        /* получение всех менеджеров с картинками */
        $adminUser->getAll($this->query, $this->status, 'userId ASC', UserTypes::ADMIN, $this->manager);
        if (!empty($adminUser->users)) {
            foreach ($adminUser->users as $managerId => $user) {
                $adminUser->users[$managerId]['statusName'] = lang('managers:statuses:' . $user['status']);
                $adminUser->users[$managerId]['accessLevelName'] = UserGroups::accessLevelName($user['accessLevel']);
                $adminUser->users[$managerId]['registered'] = langDate(adjustTime(gmdate('Y-m-d H:i', $user['registered']), false, 'Y-m-d H:i'));
                $adminUser->users[$managerId]['last_login'] = langDate(adjustTime(gmdate('Y-m-d H:i', $user['last_login']), false, 'Y-m-d H:i'));

                $adminUser->users[$managerId]['image'] = $adminUser->getFile($user['fileId']);
            }
        }
        /* получение кол-во менеджеров */
        $adminUser->total($this->query, $this->status, UserTypes::ADMIN, $this->manager);
        $pages = getPageNums($adminUser->total, $this->page, $this->limit, 0, 4, 4, 0);
        $this->smarty->assign('pageNums', $pages);
        $this->smarty->assign('managers', $adminUser->users);
        $this->smarty->assign('page', $this->page);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        /** Права доступа к данному шаблону */
        if (Managers::init()->permissions('managers')) {
            return $this->smarty->fetch('managers.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }

}









