<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\Managers;
use Mnv\Models\Maps;

/**
 * Class MapsAdmin
 * @package Mnv\Admin\Controllers
 */
class MapsAdmin extends Maps
{

    public function fetch()
    {

        $this->smarty->assign('activeItem','maps');
        $this->smarty->assign('title', lang('settings:title'));
        $this->smarty->assign('works', lang('general:works'));

        $this->map = getRequestVar('map', '', true);

        if (($this->action == 'save') && $this->save($this->map)) {
            $this->messages['saved'] = true;
        }

        $this->getMaps();

        $this->smarty->assign('map', $this->map);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('maps')) {
            return $this->smarty->fetch('maps.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}


