<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\Helpers;
use Mnv\Core\Managers;
use Mnv\Core\Test\Logger;
use Mnv\Models\Contents\Content;
use Mnv\Models\Contents\Exceptions\NoContentException;
use Mnv\Models\Contents\Exceptions\NotUpdateContentException;
use Mnv\Models\Contents\Exceptions\NotInsertContentException;

/**
 * Class NewAdmin
 * @package Mnv\Admin\Controllers
 */
class NewAdmin extends Content
{

    public function fetch()
    {
        global $SECTIONS;

        $this->smarty->assign('activeItem', 'news');
        $this->smarty->assign('title', 'Новости');
        /** statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));

        /** получение ID статьи для удаления / изменение статуса / удаление и обновление основной картинки статьи */
        $this->articleId     = (int) getRequestVar('id', '');
        $this->content       = getRequestVar('article', '', true);

        /** работа с галереей */
        $image      = getRequestVar('image', '', true);
        $gallery    = getRequestVar('gallery', '', true);
        $imageIds   = getRequestVar('imageIds', '', true);
        $imageId    = (int) getRequestVar('imageId', '');
        $picture    = getRequestVar('picture', '', true);

        $sections = Helpers::init()->getSectionTypeContent( 'news', null);
        if (count($sections) < 2) {
            $this->errors['no_sections'] = true;
        }
        $this->smarty->assign('sections', $sections);


        if ($this->action == 'add' || $this->action == 'edit') {
            try {
                $this->edit();
            } catch (NoContentException $e) { /** контент не найден */
                $this->errors['article_not_found'] = true;
            }
        }
        /** сохрание новости */
        else if ($this->action == 'save' || $this->action == 'apply') {

            /** проверка полей */
            if (empty($this->content['title'])) {
                $this->errors['title'] = true;
            }
            $this->content['isFeatured'] = $this->content['isFeatured'] ?? 0;
            /** тип контента */
            if (empty($this->content['typeContent'])) {
                $this->content['typeContent'] = 'news';
            }


            /** проверка доступных разделов для статей */
            if (empty($this->content['sectionId']) || empty($sections[$this->content['sectionId']])) $this->errors['sectionId'] = true;

            /** проверка fileName на совпадение / если пустой то fileName пропишется от последнего ID из таблицы + 1 */
            if ($fileName = $this->checkFileName($this->content['fileName'])) {
                if ($fileName == $this->content['fileName']) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $this->content['fileName'] = $fileName;
                }
            }

            /** основная картинка */
            $images['fileId'] = !empty($image) ? $image['fileId'] : null;

            /** включить / отключить галерею у данного контента */
            $this->content['enableGallery'] = isset($this->content['enableGallery']) ? 1 : 0;
            $images['gallery'] = !empty($gallery) ? $gallery : null;

            if (!empty($this->content['urlType']) && $this->content['urlType'] === 'external') {
                if (empty($this->content['externalLink'])) $this->errors['externalLink'] = true;
            } else {
                $this->content['externalLink'] = null;
            }

            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {
                /** построение url из полученного url раздела/fileName статьи . расширение файла из настроек  (html / htm)  */
                $this->content['url'] = $SECTIONS[$this->content['sectionId']]['path'] . '/' . $this->content['fileName'] . '.' . $this->config['file_extension'];

                /** если пустой ID то создаем новую статью / если существует ID то редактируем статью */
                if (empty($this->articleId)) {

                    try {
                        $this->add((array)$this->content, $images, $this->manager->userId);
                        $this->messages['saved'] = true;
                        Logger::init()->info("Добавлен контент «" . $this->content['title'] . "»", $this->manager)->save();

                        if (empty($this->errors) && $this->action === 'apply') {
                            redirect($this->adminUrl . "/new?" . $this->buildQueryString([
                                    'action'=> 'edit',
                                    'id'    => $this->articleId,
                                    'page'  => $this->page
                                ]));
                        }
                    } catch (NotInsertContentException $e) {
                        $this->errors['not_saved'] = true;
                    }

                } else {
                    try {
                        $this->update((array)$this->content, $images, $this->manager->userId);

                        $this->messages['saved'] = true;
                        Logger::init()->info("Контент «" . $this->content['title'] . "» отредактирован", $this->manager)->save();
                    } catch (NotUpdateContentException $e) {
                        $this->errors['not_saved'] = true;
                        $this->edit();
                    }
                }
            } else {
                /** если есть какие-либо ошибки в полях */
                $this->smarty->assign('action', 'edit');
            }

            if (empty($this->errors) && $this->action === 'save') {
                redirect($this->adminUrl . "/news?" . $this->buildQueryString(['page' => $this->page]));
            }

        }
        /** удаление основной картинки */
        else if ($this->action == 'deleteImage') {

            $result = $this->deleteImage($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingImage'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingImageError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** редактирование ифонмации у картинки в галереи */
        else if ($this->action == 'editPictureInfo') {

            if ($result = $this->editPictureInfo($imageId, $picture)) {
                $response = array('status' => 200, 'title' => $result->title, 'alias' => $result->alias, 'description' => $result->description, 'link' => $result->link, 'position' => $result->position);
            } else {
                $response = array('status' => 400, 'title' => '', 'alias' => '', 'description' => '', 'link' => '', 'position' => '');
            }
            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            exit();
        }
        /** сортировка картинок в галереи */
        else if ($this->action == 'sortPictures') {

            $orderBy = 1;
            foreach ($imageIds as  $imageId) {
                $this->sortPictures($imageId, $orderBy);
                $orderBy++;
            }
        }
        /** удаление картинки в галереи */
        else if ($this->action == 'deletePicture') {

            $result = array('del' => $this->deletePicture($imageId));

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            exit();
        }

//        var_dump($this->content);
        $this->smarty->assign('typeNews', array('' => 'Выберите тип', 'news' => 'Новости', 'service' => 'Сервисные акции', 'promotions' => 'Акции и спецпредложения', 'smi' => 'СМИ'));
        $this->smarty->assign('urlTypes', array('default' => 'Выбрать тип ссылки', 'modal' => 'Модальное окно', 'external' => 'Внешняя ссылка' ));

        $this->smarty->assign('article', $this->content);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('news')) {
            return $this->smarty->fetch('new.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }



}