<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers;
use Mnv\Models\Orders;

/**
 * Class OrdersAdmin
 * @package Mnv\Admin\Controllers
 */
class OrdersAdmin extends AdminMnv
{

    public function fetch()
    {
        $orders = new Orders();
        $dateSelector = new StatsDateSelector(false, 'ordersDateSelector');
        $typeSelector = new StatsTypeSelector();
        $sections = array();

        $this->smarty->assign('activeItem','orders');
        $this->smarty->assign('title', lang('orders:title'));
        $this->smarty->assign('statuses', lang('orders:statuses'));

        $orders->order	= getRequestVar('order','', true);
        $orders->orderId	= getRequestVar('id', '');
        $this->smarty->assign('sections', $sections);

//        $draw     = getRequestVar('draw', '1');
//        $start    = getRequestVar('start', '0');
//        $length   = getRequestVar('length', '10');
//
//        $searchValue = getRequestVar('search'); //$_POST['search']['value'];
//        $columnName = getRequestVar('columns'); //$_POST['columns'][$columnIndex]['data'];
//        $columnSortOrder = getRequestVar('order');// $_POST['order'][0]['dir'];

        if ($this->action == 'remove') {
            if ($orders->remove()) {
                response()->make("deleteSuccess('" . $orders->orderId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
        }
//        else if ($this->action == 'read_table') {
//
//            $ordersArr           = $orders->getTableOrders($start, $length, $searchValue, $columnSortOrder, $columnName);
//            $totalOrders         = $orders->countTableOrders();
//            $totalFilteredOrders = $orders->countTableFilteredOrders($searchValue);
//            $response = array(
//                "draw"              => intval($draw),
//                "recordsTotal"      => $totalOrders,
//                "recordsFiltered"   => $totalFilteredOrders,
//                "data"              => $ordersArr
//            );
//
//            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
//            exit();
//        }
        else {

            $orders->getAll($dateSelector->dateStart, $dateSelector->dateEnd);
            if (!empty($orders->orders)) {
                foreach ($orders->orders as $orderId => $order) {
                    $orders->orders[$orderId]->client       = json_decode($order->client);
                    $orders->orders[$orderId]->statusName   = lang('orders:statuses:'.$order->status);
                    $orders->orders[$orderId]->createdBy    = langDate(adjustTime($order->createdBy, false, 'd.m.Y H:i '));
                    $orders->orders[$orderId]->monthBy      = langDate(adjustTime($order->createdBy, false, 'F Y'));
                    $orders->orders[$orderId]->amount       = number_format($order->amount, 0, '.', ' ');
                }
            }

            /** Получение кол-во статей */
            $orders->total($dateSelector->dateStart, $dateSelector->dateEnd);

            /** pagination */
            $pages = getPageNums($orders->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalOrders', $orders->total);
            $this->smarty->assign('orders', $orders->orders);
            $this->smarty->assign('pageNums', $pages);

        }

//        $this->smarty->assign('page', $this->page);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('orders')) {
            return $this->smarty->fetch('orders.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}
