<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers;
use Mnv\Models\Payments;

/**
 * Class PaymentAdmin
 * @package Mnv\Admin\Controllers
 */
class PaymentAdmin extends AdminMnv
{

    public function fetch()
    {
        $payments = new Payments();

        $this->smarty->assign('activeItem','payments');
        $this->smarty->assign('title', lang('payments:title'));
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));

        $payments->payment      = (object) getRequestVar('payment', '',  true);
        $payments->paymentId    = (int) getRequestVar('id', '');

        if ($this->action == 'edit' || $this->action == 'add') {

         $payments->editPayment();

        } else if ($this->action == 'save' || $this->action == 'apply') {
            /* проверка полей */
            if (empty($payments->payment->name)) $this->errors['name'] = true;
            if (empty($payments->payment->fileName)) $this->errors['name'] = true;

            if ($fileName = $payments->fileNameExist($payments->payment->fileName)) {
                if ($fileName == $payments->payment->fileName) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $payments->payment->fileName = $fileName;
                }
            }

            if (isset($payments->payment->settings) && !empty($payments->payment->settings)) {
                $payments->payment->settings = json_encode($payments->payment->settings);
            }

            if (empty($this->errors)) {
                if (empty($payments->paymentId)) {
                    if ($payments->add($payments->payment, $this->manager)) {
                        $this->messages['saved'] = true;
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                    if (empty($this->errors) && $this->action == 'apply') {
                        redirect($this->adminUrl . "/payment?" . $this->buildQueryString([
                            'action'    => 'edit',
                            'id'        => $payments->paymentId,
                            'page'      => $this->page
                        ]));
                    }
                } else {
                    if ($payments->update($payments->payment, $this->manager)) {
                        $this->messages['saved'] = true;
                    } else {
                        $this->errors['not_saved'] = true;
                    }
                }
                if (empty($this->errors) && $this->action == 'save') {
                    redirect($this->adminUrl . "/payments?" . $this->buildQueryString([
                        'page'      => $this->page
                    ]));
                }

            } else {
                $payments->editPayment();
            }
        }

        if (!($payments->payment instanceof \stdClass)) $payments->payment = (object)$payments->payment;

        $payment_modules = $payments->getPaymentModules();
        $this->smarty->assign('payment_modules', $payment_modules);
        $this->smarty->assign('payment', $payments->payment);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('payments')) {
            return $this->smarty->fetch('payment.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }



}