<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Managers;
use Mnv\Models\Payments;

/**
 * Class PaymentsAdmin
 * @package Mnv\Admin\Controllers
 */
class PaymentsAdmin extends AdminMnv
{

    public function fetch()
    {
        $payments = new Payments();

        $this->smarty->assign('activeItem','payments');
        $this->smarty->assign('title', lang('payments:title'));
        $this->smarty->assign('statuses', lang('general:statuses'));

        $payments->paymentId = (int) getRequestVar('id','');

        if ($this->action == 'remove') {
            if ($payments->deletePayment()) {
                response()->make("deleteSuccess('" . $payments->paymentId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit;
        } else if ($this->action == 'status') {
            if ($payments->statusPayment()) {
                response()->json($payments->result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            }
            exit;
        }

        $payments->getAllPayments();
        $payments->countPayments();

        $pageNums = getPageNums($payments->total,1, 30, 0, 4, 4, 0);
        $this->smarty->assign('totalPayments', $payments->total);
        $this->smarty->assign('payments', $payments->payments);
        $this->smarty->assign('pageNums', $pageNums);


        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('payments')) {
            return $this->smarty->fetch('payments.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }

}