<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\Helpers;
use Mnv\Core\Managers;
use Mnv\Core\Test\Logger;
use Mnv\Models\Brands;
use Mnv\Models\Countries;
use Mnv\Models\Features;
use Mnv\Models\Variants;
use Mnv\Models\Contents\Product;
use Mnv\Models\Contents\Exceptions\NoContentException;
use Mnv\Models\Contents\Exceptions\NotUpdateContentException;
use Mnv\Models\Contents\Exceptions\NotInsertContentException;

/**
 * Class ProductAdmin
 * @package Mnv\Admin\Controllers
 */
class ProductAdmin extends Product
{

    protected $val;

    protected $variants;
    protected $options;

    public int $sectionId;
    public int $featureId;

    public function fetch()
    {
        global $SECTIONS;

        $variantProduct = new Variants();
        $feature        = new Features();
        $brands         = new Brands();
        $countries      = new Countries();

        $features = array();

        $this->smarty->assign('activeItem', $this->module.'s');
        $this->smarty->assign('title', lang($this->module.'s:title'));
        /** statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));

        $this->smarty->assign('countryList', $countries->getSelectCountries());
        /** бренды для продута */
        $this->smarty->assign('brands',  $brands->getBrands());

        $typeContent = getRequestVar('typeContent', $this->module.'s');

        /** получение ID для удаления / изменение статуса / удаление и обновление основной картинки */
        $this->sectionId    = (int) getRequestVar('sectionId', '');
        $this->featureId    = (int) getRequestVar('featureId', '');

        /** получение параметров `product` */
        $this->articleId    = (int) getRequestVar('id', '');
        $this->content      = getRequestVar('product', '', true);

        /** свойства товара */
        $options                = getRequestVar('options', '', true);
        $icons                  = getRequestVar('icons', '', true);
        $newFeaturesNames       = getRequestVar('new_features_names', '', true);
        $newFeaturesValues      = getRequestVar('new_features_values', '', true);
        $newFeaturesIcons       = getRequestVar('new_features_icons', '', true);

        /** варианты товара */
        $variants    = getRequestVar('variants', '', true);

        /** работа с галереей */
        $image        = getRequestVar('image', '', true);
        $gallery      = getRequestVar('gallery', '', true);
        $imageIds     = getRequestVar('imageIds', '', true);
        $imageId      = (int) getRequestVar('imageId', '');
        $picture      = getRequestVar('picture', '', true);


        $sections = Helpers::init()->getSectionContent(0, $typeContent);
        if (count($sections) < 2) {
            $this->errors['no_sections'] = true;
        }
        $this->smarty->assign('sections', $sections);

        // action добавление/редактирование
        if ($this->action == 'add' || $this->action == 'edit') {
            try {
                $this->edit();
            } catch (NoContentException $e) { /** контент не найден */
                echo "notFound();";
                exit;
            }
        }
        // action сохранение
        else if ($this->action == 'save' || $this->action == 'apply') {

            /** проверка полей */
            if (empty($this->content['title'])) $this->errors['title'] = true;
            /** тип контента */
            if (empty($this->content['typeContent'])) $this->content['typeContent'] = $typeContent;

            /** проверка доступных разделов */
            if (empty($this->content['sectionId']) || empty($sections[$this->content['sectionId']])) {
                $this->errors['sectionId'] = true;
            }
            //if (empty($this->content['brand'])) $this->errors['brand'] = true;

            /** проверка fileName на совпадение / если пустой то fileName пропишется от последнего ID из таблицы + 1 */
            if ($fileName = $this->checkFileName($this->content['fileName'])) {
                if ($fileName == $this->content['fileName']) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $this->content['fileName'] = $fileName;
                }
            }

            /** основная картинка */
            $images['fileId'] = !empty($image) ? $image['fileId'] : null;

            /** включить / отключить галерею у данного контента */
            $this->content['enableGallery'] = isset($this->content['enableGallery']) ? 1 : 0;
            $images['gallery'] = !empty($gallery) ? $gallery : null;

            $sectionFeatures = array();

            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {
                /** построение url из полученного url раздела/fileName статьи . расширение файла из настроек  (html / htm)  */
                $this->content['url'] = $SECTIONS[$this->content['sectionId']]['path'] . '/' . $this->content['fileName'].'.'.$this->config['file_extension'];

                /** если пустой ID то создаем новый продукт / если существует ID то редактируем продукт */
                if (empty($this->articleId)) {

                    try {
                        $this->add($this->content, $images, $this->manager->userId);

                        if (is_array($variants)) {
                            $variantsIds = array();
                            foreach ($variants as &$variant) {
                                if ($variant['stock'] == '∞' || $variant['stock'] == '') {
                                    $variant['stock'] = null;
                                }

                                /** добавление варианта */
                                $variant['productId'] = $this->articleId;
                                $variant['id'] = $variantProduct->addVariant($variant);

                                /** возвращает вариант товара */
                                $variant = $variantProduct->getVariant($variant['id']);
                                if (!empty($variant['id'])) $variantsIds[] = $variant['id'];
                            }

                            /** Отсортировать  варианты */
                            asort($variantsIds);
                            $i = 0;
                            foreach ($variantsIds as $variantId) {
                                /** обновляет вариант товара  */
                                $variantProduct->updateVariant($variantsIds[$i], ['orderBy' => $variantId]);
                                $i++;
                            }
                        }

                        /** Характеристики продукта */

                        /** получение свойств для продукта */
                        $sectionFeatureIds = $feature->getAllProductFeatureIds($this->content['sectionId']);
                        if (is_array($options)) {
                            foreach ($options as $featureId => $option) {
                                if (in_array($featureId, $sectionFeatureIds, true)) {
                                    $feature->updateOption($this->articleId, $featureId, $option, $icons[$featureId]);
                                }
                            }
                        }

                        /** Новые характеристики продукта */
                        if (is_array($newFeaturesNames) && is_array($newFeaturesValues)) {
                            foreach($newFeaturesNames as $i => $name) {
                                $value = trim($newFeaturesValues[$i]);
                                $icon = trim($newFeaturesIcons[$i]);
                                if (!empty($name) && !empty($value)) {
                                    $featureId = $feature->existsFeature(trim($name));
                                    if (empty($featureId)) {
                                        $featureId = $feature->addFeature(['sectionIds' => json_encode([$this->content['sectionId']], JSON_THROW_ON_ERROR), 'name'=> trim($name)]);
                                    }

                                    $feature->updateOption($this->articleId, $featureId, $value, $icon);
                                }
                            }
                            /** возвращаем характеристики продукта */
                            $options = $feature->getProductOptions($this->articleId);
                            $this->smarty->assign('options', $options);
                        }

                        $this->messages['saved'] = true;
                        Logger::init()->info("Добавлен контент «" . $this->content['title'] . "»", $this->manager)->save();

                        if (empty($this->errors) && $this->action == 'apply') {
                            redirect($this->adminUrl . "/" . $this->module . "?" . $this->buildQueryString([
                                    'action'=> 'edit',
                                    'id'    => $this->articleId,
                                    'page'  => $this->page
                            ]));
                        }

                    } catch (NotInsertContentException $e) {
                        $this->errors['not_saved'] = true;
                    }

                } else {

                    try {
                        /** обновляем сам продукт */
                        $this->update((array)$this->content, $images, $this->manager->userId);

                        if (is_array($variants)) {
                            $variantsIds = array();

                            foreach($variants as &$variant) {
                                if ($variant['stock'] == '∞' || $variant['stock'] == '') {
                                    $variant['stock'] = null;
                                }

                                /** если уже существует вариант продукта то обновляем его в противном случае добавляем */
                                if (isset($variant['id']) && !empty($variant['id'])) {
                                    /** обновляем вариант продукта  */
                                    $variantProduct->updateVariant($variant['id'], $variant);

                                } else {
                                    /** добавление варианта */
                                    $variant['productId'] = $this->articleId;
                                    $variant['id'] = $variantProduct->addVariant($variant);
                                }

                                /** возвращаем вариант продукта  */
                                $variant = $variantProduct->getVariant($variant['id']); // ОШИБКА
                                if (!empty($variant['id'])) $variantsIds[] = $variant['id'];
                            }

                            /** возвращает варианты товара */
                            $currentVariants = $variantProduct->getVariants($this->articleId);

                            /** Удаляем непереданные варианты */
                            foreach($currentVariants as $currentVariant) {
                                if (!in_array($currentVariant['id'], $variantsIds, true)) {
                                    $variantProduct->deleteVariant($currentVariant['id']);
                                }
                            }

                            /** Отсортировать  варианты */
                            asort($variantsIds);
                            $i = 0;
                            foreach($variantsIds as $variant_id) {
                                /** обновляем вариант продукта */
                                $variantProduct->updateVariant($variantsIds[$i], ['orderBy' => $variant_id]);
                                $i++;
                            }
                        }

                        /** Характеристики продукта */

                        /** Удалим все характеристики из продукта */
                        $productOptions = $feature->getProductOptions($this->articleId);
                        if (!empty($productOptions)) {
                            foreach ($productOptions as $productOption) {
                                $feature->deleteOption($this->articleId, $productOption['featureId']);
                            }
                        }
                        /** получение свойств для продукта */
                        $sectionFeatureIds = $feature->getAllProductFeatureIds($this->content['sectionId']);
                        if (is_array($options)) {
                            foreach ($options as $featureId => $option) {
                                if (in_array($featureId, $sectionFeatureIds)) {
                                    $feature->updateOption($this->articleId, $featureId, $option, $icons[$featureId]);
                                }
                            }
                        }

                        /** Новые характеристики */
                        if (is_array($newFeaturesNames) && is_array($newFeaturesValues)) {
                            foreach($newFeaturesNames as $i => $name) {
                                $value = trim($newFeaturesValues[$i]);
                                $icon = trim($newFeaturesIcons[$i]);
                                if (!empty($name) && !empty($value)) {
                                    $featureId = $feature->existsFeature(trim($name));
                                    if (empty($featureId)) {
                                        $featureId = $feature->addFeature(['sectionIds' => json_encode([$this->content['sectionId']], JSON_THROW_ON_ERROR), 'name' => trim($name)]);
                                    }
                                    $feature->updateOption($this->articleId, $featureId, $value, $icon);
                                }
                            }
                            /** возвращаем характеристики продукта */
                            $options = $feature->getProductOptions($this->articleId);
                            $this->smarty->assign('options', $options);
                        }

                        $this->messages['saved'] = true;
                        Logger::init()->info("Контент «" . $this->content['title'] . "» отредактирован", $this->manager)->save();

                    } catch (NotUpdateContentException $e) {
                        $this->edit();
                        $this->errors['not_saved'] = true;
                    }
                }
            }

            /** если есть какие-либо ошибки в полях */
            $this->edit();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->adminUrl . "/" . $this->module . "s?" . $this->buildQueryString(['page' => $this->page]));
            }

        }
        else if ($this->action == 'deleteImage') {
            $result = $this->deleteImage($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingImage'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingImageError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        else if ($this->action == 'editPictureInfo') {

            if ($result = $this->editPictureInfo($imageId, $picture)) {
                $response = array('status' => 200, 'title' => $result->title, 'alias' => $result->alias, 'description' => $result->description, 'link' => $result->link, 'position' => $result->position);
            } else {
                $response = array('status' => 400, 'title' => '', 'alias' => '', 'description' => '', 'link' => '', 'position' => '');
            }
            
            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
        }

        else if ($this->action == 'sortPictures') {

            $this->sortPictures($imageIds);

        }

        else if ($this->action == 'deletePicture') {
            $result = $this->deletePicture($imageId)
                ? array('status' => 200, 'message' => lang('deletingImage'), 'type', 'success')
                : array('status' => 500, 'message' => lang('deletingImageError'), 'type', 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
        }
        /** получить свойства товара от выбранного раздела */
        else if ($this->action == 'features') {
            $features = $feature->getAllProductFeatures($this->sectionId);
            if (!empty($this->articleId)) $featureOptions = $feature->getProductOptions($this->articleId);
            foreach($features as &$ft) {
                $ft->value = isset($featureOptions[$ft->id]) ? $featureOptions[$ft->id]->value : '';
            }

            response()->json($features, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

        }

        // получить свойства товара от выбранного раздела
//        else if ($this->action == 'featureId') {
//
//            $featureValue = $feature->getProductFeatureValue($this->featureId);
//            response()->json($featureValue, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
//        }


        /** вывод свойств продукта `variants` (название свойств) */
        if (isset($this->content['sectionId'])) {
            $features = $feature->getAllProductFeatures($this->content['sectionId']);
        }
        $this->smarty->assign('features', $features);

        /** вывод характеристик продукта `options` (название характеристик, значение характеристик ) */
//        $options = $feature->getProductOptions($this->articleId);
//        print_r($options);
        $this->smarty->assign('options', $feature->getProductOptions($this->articleId));

        /** вывод варианты товара `product_variants` (название, артикул, цена, старая цена, кол-во) */
        $this->smarty->assign('product_variants', $variantProduct->getVariants($this->articleId));


//        print_r($features);
//        print_r($product->content);

        $this->smarty->assign('product', $this->content);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

//        var_dump($admin->access);

        if (Managers::init()->permissions('products')) {
            return $this->smarty->fetch('product.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }



}