<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\Helpers;
use Mnv\Core\AdminMnv;

use Mnv\Core\Managers;
use Mnv\Core\Test\Logger;
use Mnv\Models\Sections\Sections;
use Mnv\Models\Users\UserGroups;

/**
 * Class SectionAdmin
 * @package Mnv\Admin\Controllers
 */
class SectionAdmin extends Sections
{
    protected $id;
    protected $val;

    public function fetch()
    {
        global $SECTIONS;

        $oldSection = '';

        $this->smarty->assign('title', lang('sections:title'));
        $this->smarty->assign('activeItem', 'sections');

        $this->section     = getRequestVar('section', '', true);
        $this->parentId    = (int) getRequestVar('parentId');
        $this->sectionId   = (int) getRequestVar('id');

        /** для работы с галереей */
        $image      = getRequestVar('image', '', true);
        $gallery    = getRequestVar('gallery', '', true);
        $docs       = getRequestVar('docs', '', true);

        $picture   = getRequestVar('picture', '', true);
        $imageId   = (int) getRequestVar('imageId');
        $imageIds  = getRequestVar('imageIds', '', true);

        /** редактирование или добавление */
        if ($this->action == 'edit') {
            $this->edit();
        }
        /** сохранение */
        else if ($this->action == 'save' || $this->action == 'apply') {

            /** проверка полей */
            $this->section['name'] = trim($this->section['name']);
            if (empty($this->section['name'])) {
                $this->errors['name'] = true;
            }

            /** параметры input(checkbox) int 1/0 */
            $this->section['showMainPage']  = $this->section['showMainPage'] ?? 0;
            $this->section['topMenu']       = $this->section['topMenu'] ?? 0;
            $this->section['footerMenu']    = $this->section['footerMenu'] ?? 0;
            $this->section['enableGallery'] = $this->section['enableGallery'] ?? 0;
            $this->section['enableIcon']    = $this->section['enableIcon'] ?? 0;

//            $this->section['sectionIds]   = !empty($this->section['sectionIds]) ? json_encode($this->section['sectionIds]) : '';


            /** проверяем существует ли главная страница если да то ошибка / если нет то устанавливаем ей параметры type и parentId */
            if ($this->section['fileName'] == 'index') {
                $this->section['type'] = 'plain';
                $this->section['parentId'] = 0;
                if ($fileName = $this->isFileNamePage($this->section['fileName'])) {
                    if ($fileName == $this->section['fileName']) {
                        $this->errors['pageFileNameExists'] = true;
                    } else {
                        $this->section['fileName'] = $fileName;
                    }
                }
            }

            /** проверка наличия  */
            if (!empty($this->sectionId)) {
                $oldSection = $SECTIONS[$this->sectionId] ?? null;
            }

            if (empty($this->section['fileName'])) {
                $this->errors['fileName'] = true;
            }
            if (empty($this->section['parentId'])) {
                $this->section['parentId'] = 0;
            }

            /** проверяем существует ли `fileName` если да то ошибка */
            if ($fileName = $this->isFileNameSection($this->section['fileName'])) {
                if ($fileName == $this->section['fileName']) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $this->section['fileName'] = $fileName;
                }
            }

            if (preg_match('/^(admin|images|files)$/i', $this->section['fileName'])) {
                $this->errors['fileNameProhibited'] = true;
            }
            if (preg_match('/[^0-9a-zA-Z\-_\.,]/i', $this->section['fileName'])) {
                $this->errors['fileNameCharacters'] = true;
            }

            $templates = searchDir(THEME_ROOT, '*.tpl');
            if (!in_array($this->section['templateName'], $templates, true)) {
                $this->section['templateName'] = '';
            }
            if (!in_array($this->section['subTemplateName'], $templates, true)) {
                $this->section['subTemplateName'] = '';
            }
            if (!in_array($this->section['artTemplateName'], $templates, true)) {
                $this->section['artTemplateName'] = '';
            }

            $images['fileId'] = !empty($image) ? $image['fileId'] : '';
            $images['gallery'] = !empty($gallery) ? $gallery : '';


            if (isset($docs)) {
                $images['docs'] = !empty($docs) ? $docs : '';
            }

            if (!empty($this->section['urlType']) && $this->section['urlType'] == 'external') {
                if (empty($this->section['externalLink'])) {
                    $this->errors['externalLink'] = true;
                }
            } else {
                $this->section['externalLink'] = null;
            }

//            print_r($this->section);
            if (empty($this->errors)) {

                if (empty($this->sectionId)) {
                    try {
                        if ($this->add($this->section, $images, $this->manager->userId)) {

                            if (!saveSerializations()) {
                                $this->errors['serializations'] = true;
                            }
                            if (!writeHtaccess()) {
                                $this->errors['htaccess'] = true;
                            }

                            Logger::init()->info("Добавлен новый раздел «" . $this->section['name'] . "»", $this->manager)->save();
                            $this->messages['saved'] = true;

                            if (empty($this->errors) && $this->action == 'apply') {
                                redirect($this->adminUrl . "/" . $this->module . "?" . $this->buildQueryString([
                                        'action'    => 'edit',
                                        'id'        => $this->sectionId,
                                        'parentId'  => $this->parentId,
                                        'page'      => $this->page
                                    ]));
                            }
                        } else {
                            $this->errors['not_saved'] = true;
                        }
                    } catch (\SmartyException $e) {
                    }
                } else if ($this->update($this->section, $oldSection, $images, $this->manager->userId)) {
                    if (isset($oldSection->parentId) && $this->parentId != $oldSection->parentId) {
                        /** обновить порядок сортировки, если был изменен родитель */
                        $this->writeSortOrders($this->parentId);
                        $this->writeSortOrders($oldSection->parentId);
                    }

                    if (!saveSerializations()) {
                        $this->errors['serializations'] = true;
                    }
                    if (!writeHtaccess()) {
                        $this->errors['htaccess'] = true;
                    }

                    Logger::init()->info("Раздел «" . $this->section['name'] . "» отредактирован", $this->manager)->save();
                    $this->messages['saved'] = 'saved';
                } else {
                    $this->errors['not_saved'] = true;
                }

                $this->parentId = $this->section['parentId'];
                if (!saveSerializations()) {
                    $this->errors['serializations'] = true;
                }
                if (!writeHtaccess()) {
                    $this->errors['htaccess'] = true;
                }

                /* если есть какие-либо ошибки в полях */
                $this->smarty->assign('action', 'edit');
            }

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->adminUrl . "/sections?" . $this->buildQueryString([
                    'parentId'  => $this->parentId,
                    'page'      => $this->page
                ]));
            }
        }
        /** удаление основной картинки */
        else if ($this->action == 'deleteImage') {
            $result = $this->deleteImage($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingImage'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingImageError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** редактирование картинки в галереи */
        else if ($this->action == 'editPictureInfo') {

            $result = $this->editPictureInfo($imageId, $picture);
            if (!empty($result)) {
                $response = array('status' => 200, 'title' => $result->title, 'alias' => $result->alias, 'description' => $result->description, 'link' => $result->link, 'position' => $result->position);
            } else {
                $response = array('status' => 400, 'title' => '', 'alias' => '', 'description' => '', 'link' => '', 'position' => '');
            }

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json; charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** сортировка галереи */
        else if ($this->action == 'sortPictures') {

            $this->sortPictures($imageIds);
        }
        /** удаление картинки из галереи */
        else if ($this->action == 'deletePicture') {

            $result = $this->deletePicture($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingImage'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingImageError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
         }

        /** удаление файлов docs */
        else if ($this->action == 'deleteDocs') {

            $result = $this->deleteDocs($imageId)
                ? array('status' => 200, 'message' => lang('deletingDocs'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('deletingDocsError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }



//        print_r($this->section);

        $this->smarty->assign('section', $this->section);

        if (!empty($this->sectionId)) {
            $this->smarty->assign('parents', Helpers::init()->getSectionOptions($this->sectionId));
        } else {
            $this->smarty->assign('parents', Helpers::init()->getSectionOptions());
        }

        /* template options */
        $templates = searchDir(THEME_ROOT, '*.tpl');
        array_unshift($templates, lang('general:useDefaultTemplate'));
        $this->smarty->assign('templates', $templates);

        /* caching time options */
        $cachingTimeOptions = array();
        for($i = 1; $i <= 60; $i++) {
            $cachingTimeOptions[$i] = $i;
        }
        $this->smarty->assign('cachingTimeOptions', $cachingTimeOptions);
        $this->smarty->assign('cachingPeriodOptions', lang('general:cachingPeriodOptions'));
        $this->smarty->assign('statuses', lang('sections:statuses'));
        $this->smarty->assign('typeContents', lang('sections:typeContents'));
        $this->smarty->assign('types', lang('sections:types'));
        $this->smarty->assign('urlTypes', array('default' => 'Выбрать тип ссылки', 'external' => 'Внешняя ссылка' ));


        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('sections')) {
            return $this->smarty->fetch('section.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }






}
	
	

	
