<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\DB;
use Mnv\Core\Helpers;
use Mnv\Core\Managers;
use Mnv\Core\UserInfo;
use Mnv\Models\Settings;
use Mnv\Core\Locale\Charset;
use Mnv\Core\Locale\LanguageSelection;

/**
 * Class SettingsAdmin
 * @package Mnv\Admin\Controllers
 */
class SettingsAdmin extends Settings
{

    public function fetch()
    {

        $this->smarty->assign('activeItem','settings');
        $this->smarty->assign('title', lang('settings:title'));

        $this->setting  = getRequestVar('settings', '', true);
        $date           = getRequestVar('date', '');

        if ($this->action == 'save') {

            if (empty($this->setting['convert_filename_to_lowercase'])) $this->setting['convert_filename_to_lowercase'] = 0;
            if (empty($this->setting['statistics_enabled'])) $this->setting['statistics_enabled'] = 0;

            if (empty($this->setting['comments_enabled']))                     $this->setting['comments_enabled'] = 0;
            if (empty($this->setting['comments_must_be_approved']))            $this->setting['comments_must_be_approved'] = 0;
            if (empty($this->setting['comments_whitelist_enabled']))           $this->setting['comments_whitelist_enabled'] = 0;
            if (empty($this->setting['comments_blacklist_enabled']))           $this->setting['comments_blacklist_enabled'] = 0;
            if (empty($this->setting['comments_editors_may_approve']))         $this->setting['comments_editors_may_approve'] = 0;
            if (empty($this->setting['comments_captcha_enabled']))             $this->setting['comments_captcha_enabled'] = 0;
            if (empty($this->setting['comments_strip_html']))                  $this->setting['comments_strip_html'] = 0;
            if (empty($this->setting['comments_convert_links']))               $this->setting['comments_convert_links'] = 0;
            if (empty($this->setting['comments_email_confirmation_required'])) $this->setting['comments_email_confirmation_required'] = 0;

            if (empty($this->setting['allow_watermark']))            $this->setting['allow_watermark'] = 0;
            if (empty($this->setting['save_original_image']))        $this->setting['save_original_image'] = 0;
            if (empty($this->setting['keep_original_image_name']))   $this->setting['keep_original_image_name'] = 0;
            if (empty($this->setting['save_thumbnail_image']))       $this->setting['save_thumbnail_image'] = 0;
            if (empty($this->setting['force_webp']))                 $this->setting['force_webp'] = 0;
            if (empty($this->setting['mail_bcc']))                   $this->setting['mail_bcc'] = 0;

            if (empty($this->setting['cache_enabled_index']))        $this->setting['cache_enabled_index'] = 0;
            if (empty($this->setting['cache_enabled_article']))      $this->setting['cache_enabled_article'] = 0;
            if (empty($this->setting['cache_enabled_section']))      $this->setting['cache_enabled_section'] = 0;
            if (empty($this->setting['cache_enabled_rss']))          $this->setting['cache_enabled_rss'] = 0;
            if (empty($this->setting['cache_enabled_sitemap']))      $this->setting['cache_enabled_sitemap'] = 0;

            if (empty($this->setting['feedback_captcha_enabled']))   $this->setting['feedback_captcha_enabled'] = 0;
            if (empty($this->setting['website_down']))               $this->setting['website_down'] = 0;
            if (empty($this->setting['compress_js_css']))            $this->setting['compress_js_css'] = 0;
            if (empty($this->setting['mod_deflate']))                $this->setting['mod_deflate'] = 0;
            if (empty($this->setting['mod_headers']))                $this->setting['mod_headers'] = 0;
            if (empty($this->setting['mod_expires']))                $this->setting['mod_expires'] = 0;
            if (empty($this->setting['website_language']))           $this->setting['website_language'] = '';
            if (empty($this->setting['telegram_send']))              $this->setting['telegram_send'] = 0;
            if (empty($this->setting['error_test']))                 $this->setting['error_test'] = 0;
            if (empty($this->setting['check_banned_ips']))           $this->setting['check_banned_ips'] = 0;
            if (empty($this->setting['twoFactorAuth']))              $this->setting['twoFactorAuth'] = 0;

            if (empty($this->setting['timezone']))
                $this->setting['timezone'] = $this->setting['timezone'];

            foreach (lang('langtimezones:timezone') as $key => $langtimezone) {
                if ($this->setting['timezone'] == $key)  {
                    $timezone = explode(":", $langtimezone);
                    $this->setting['hour_adjustment']   = $timezone[0];
                    $this->setting['minute_adjustment'] = $timezone[1];
                }
            }
            if (empty($this->setting['site_url'])) {
                $this->setting['site_url'] = GLOBAL_URL;
            }


            $this->save();

            /**  получить обновленные настройки */
            $this->smarty->assign('config', $this->readListConfig());

            $this->messages['saved'] = true;

            if (!saveSerializations()) {
                $this->errors['serializations'] = true;
            }
            if (!writeHtaccess()) {
                $this->errors['htaccess'] = true;
            }

        }
        /** очистка кеша */
        else if  ($this->action == 'clear_cache') {
            $this->clearCache();
            exit;
        }
        /** удаление статистики */
        else if  ($this->action == 'delete_stats') {
            $this->deleteStatsPriorTo($date);
            exit;
        }
        /** тестирование подключения smtp */
        else if ($this->action ==  'test_smtp') {
            $this->testSMTP();
            response()->json($this->resultSmtp, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }


        for($i = 100; $i >= 70; $i = $i - 5) {
            $thumbQualityOptions[$i] = $i;
        }
        $this->smarty->assign('thumbQualityOptions', $thumbQualityOptions);

        for($i = 1; $i <= 10; $i++) {
            $sectionDepthOptions[$i] = $i;
        }
        $this->smarty->assign('sectionDepthOptions', $sectionDepthOptions);

        /* caching time options */
        for($i = 1; $i <= 60; $i++) {
            $cachingTimeOptions[$i] = $i;
        }
        $this->smarty->assign('cachingTimeOptions', $cachingTimeOptions);

        $this->smarty->assign('cachingPeriodOptions', lang('general:cachingPeriodOptions'));

        $this->smarty->assign('adjustedTime', langDate(adjustTime(gmdate('Y-m-d H:i:s'), false, 'F j, Y - H:i')));
        $this->smarty->assign('gmtTime', langDate(gmdate('F j, Y - H:i')));

        if ($deleteStatsTime = DB::init()->connect()->table('stats_visitors')->min('firstVisitOn')->getValue()) {
            $deleteStatsTime = strtotime($deleteStatsTime);
        } else {
            $deleteStatsTime = time() - 60*60*24*365;
        }

        $this->smarty->assign('deleteStatsTime', $deleteStatsTime);

//        /** инициализировать обновленные настройки */
//        Config::init()->config();

        /** получить обновленные настройки */
        $this->smarty->assign('config', $this->readListConfig());

        /** получить из папки themes языковые версии сайта(шаблоны) */
        $this->smarty->assign('themes', Helpers::init()->getThemes());
        /** с файла ru.inc.php получить разные спадающие списки <select> */
        $this->smarty->assign('ports',          lang('settings:mails:ports'));
        $this->smarty->assign('secures',        lang('settings:mails:secures'));
        $this->smarty->assign('methods',        lang('settings:users:methods'));
        $this->smarty->assign('mailTransports', lang('settings:mails:mailTransports'));
        $this->smarty->assign('langtimezones',  lang('langtimezones:langtimezone'));
        $this->smarty->assign('captchas',       lang('settings:captchas'));
        $this->smarty->assign('timeformats',    lang('settings:timeFormats'));
        $this->smarty->assign('fileExtension',  lang('settings:fileExtension'));
        $this->smarty->assign('separators',     lang('settings:separators'));
        $this->smarty->assign('driver',         lang('settings:driver'));
        $this->smarty->assign('works',          lang('general:works'));
        /** languages */
        $this->smarty->assign('adminLangs',         getLanguages());
        $this->smarty->assign('languageOptions',    LanguageSelection::$languageOptions);
        $this->smarty->assign('languageCharsets',   Charset::$languageCharsets);
        $this->smarty->assign('charsetOptions',     Charset::$charsetOptions);


        $this->smarty->assign('ADMINIP', UserInfo::get_ip());

        if(!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if(!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if (Managers::init()->permissions('settings')) {
            return $this->smarty->fetch('settings.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }
}
