<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\Managers;
use Mnv\Models\Socials\Socials;

/**
 * Class SocialsAdmin
 * @package Mnv\Admin\Controllers
 */
class SocialsAdmin extends Socials
{

    public function fetch()
    {

        $this->smarty->assign('activeItem','socials');
        $this->smarty->assign('title', lang('settings:social'));

        $this->socialId  = (int) getRequestVar('id','');
        $socialIds          = getRequestVar('social', '',  true);

        if  ($this->action == 'remove') {

            if ($this->remove()) {
                response()->make("deleteSuccess('" . $this->socialId . "');", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            } else {
                response()->make("deleteError();", \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'text/html;charset=UTF-8', 'Charset' => 'utf-8'])->send();
            }
            exit();

        } else if ($this->action == 'status') {

            $result = $this->status();
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            exit();

        } else if ($this->action == 'reorder') {

            $this->reorder($socialIds);

        }

        /** получение всех соц. сетей */
        $this->getAll();
        if (!empty($this->socials)) {
            foreach ($this->socials as $socialId => $social) {
                $this->socials[$socialId]['statusName'] = lang('general:statuses:' . $social['status']);
            }
        }

        $pages = getPageNums($this->total, 1, 50, 0, 4, 4, 0);
        /** вывод в шаблон результатов */
        $this->smarty->assign('totalSocials', $this->total);
        $this->smarty->assign('socials', $this->socials);
        $this->smarty->assign('pageNums', $pages);


        /** Права доступа к данному шаблону */
        if (Managers::init()->permissions('socials')) {
            return $this->smarty->fetch('socials.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}



