<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\Managers;
use Mnv\Models\Stats;
use Mnv\Core\AdminMnv;


/**
 * Class StatsErrorsAdmin
 * @package Mnv\Admin\Controllers
 */
class StatsErrorsAdmin extends AdminMnv
{

    public function fetch()
    {
        $stats = new Stats();
        $dateSelector       = new StatsDateSelector(false, null);
        $errorCodeSelector  = new StatsErrorCodeSelector();

        $this->smarty->assign('activeItem','errors');
        $this->smarty->assign('title', lang('stats:errorsTitle'));

        $errors = $stats->getStatsErrors($dateSelector->dateStart, $dateSelector->dateEnd, $errorCodeSelector->filterErrorCode);
        if (!empty($errors)) foreach($errors as $error) {
            if (!empty($error->referer)) {
                $parseReferer = parseReferer($error->referer);
                if (isset($parseReferer['refererUrl'])) $error->refererUrl = $parseReferer['refererUrl'];
                if (isset($parseReferer['refererWebsite'])) $error->refererWebsite = $parseReferer['refererWebsite'];
            }

        }

        /* page numbering */
        $totalItems = $stats->getTotalStatsErrors($dateSelector->dateStart, $dateSelector->dateEnd, $errorCodeSelector->filterErrorCode);

        $pages = getPageNums($totalItems, $this->page, $this->limit, 0, 4, 4, 0);

        $this->smarty->assign('errors', $errors);
        $this->smarty->assign('pageNums', $pages);
        $this->smarty->assign('totalItems', $totalItems);
        $this->smarty->assign('page', $this->page);

        if (Managers::init()->permissions('errors')) {
            return $this->smarty->fetch('stats/errors.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }
}
