<!-- Page header -->
<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<a class="btn btn-sm btn-primary" data-popup="popover-solid" data-trigger="hover" title="{general:add}" data-placement="top" href="{$adminUrl}/brand?action=add{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="{$adminUrl}/brands" class="breadcrumb-item">{$title}</a>
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">
                {include file="module/show-by.tpl" url="{$adminUrl}/brands"}
			</div>
		</div>
	</div>
</div>
<!-- /page header -->


<!-- Content area -->
<div class="content">
	<div class="row">
		<div class="col-md-12">
			<div class="card">
		        {include file="stats/form/selectors.tpl" filter=true url="{$adminUrl}/brands" filterDate=false}
			</div>
			<div class="card">
				<div class="">
					<table class="table table-xs table-togglable table-striped table-hover" id="brands">
						<thead>
							<tr>
								<th data-hide="ID" class="text-center" width="30">{general:table:id}</th>
								<th data-hide="image" class="text-center" width="50">{general:table:image}</th>
								<th data-toggle="true">{general:table:product}</th>
								<th data-hide="phone" class="text-center">{general:table:status}</th>
								<th class="text-center text-muted" width="30"><i class="icon-checkmark3"></i></th>
							</tr>
						</thead>

			            {if !empty($brands)}
							<tbody class="selectable-demo-list brands_list" id="brand_list">

			                {foreach item=brand from=$brands name=brands}
								<tr id="brand-{$brand.brandId}" data-id="{$brand.brandId}" class="{if $brand.status eq 'hidden'}table-warning{/if}">
									<td class="text-nowrap">{$brand.brandId}</td>
									<td class="text-center"><img src="{if isset($brand.image)}{$brand.image->small}{else}/admin/assets/img/no_images.jpg{/if}" class="img-preview" alt="{$brand.name}"/></td>
									<td><b>{$brand.name}</b></td>
									<td class="text-center" id="status-{$brand.brandId}">{$brand.statusName nofilter}</td>
									<td class="text-center">
										<div class="list-icons">
											<a class="list-icons-item text-primary-600" data-popup="popover-solid" data-trigger="hover" title="{general:edit}" data-placement="top" href="{$adminUrl}/brand?action=edit&id={$brand.brandId}{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-pencil7"></i></a>
											<div class="list-icons-item dropdown">
												<a href="#" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>
												<div class="dropdown-menu dropdown-menu-right">
													<a class="dropdown-item" href="{$adminUrl}/brand?action=edit&id={$brand.brandId}{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-pencil7"></i> {general:edit}</a>
													<a href="javascript:void('');" id="brand-status-{$brand.brandId}" class="dropdown-item ajax_action {if $brand.status eq 'visible'}active_class{/if}" data-module="brands" data-action="status" data-id="{$brand.brandId}" name="status" value="1" ><i class="{if $brand.status eq 'visible'}icon-eye{else}icon-eye-blocked{/if}"></i> {general:status}</a>
													<div class="dropdown-divider"></div>
													<a href="javascript:void('');" class="dropdown-item" onclick="remove({$brand.brandId}, '{$brand.name|escape}', 'brands');"><i class="icon-cross2"></i> {general:delete}</a>
												</div>
											</div>
										</div>
									</td>
								</tr>
			                {/foreach}

							</tbody>
			            {else}
							<tbody><tr class="odd"><td class="data none" colspan="8" align="center">- {general:none} -</td></tr></tbody>
			            {/if}
					</table>
				</div>
		        {include file="module/pagination.tpl" url="{$adminUrl}/brands" params="{$buildQueryString}"}
			</div>
		</div>
	</div>
</div>

<style>
    table.fixedHeader-floating{
        position:fixed !important;
        background-color:white
    }
    table.fixedHeader-floating.no-footer{
        border-bottom-width:0
    }
    table.fixedHeader-locked {
        position:absolute !important;
        background-color:white
    }
    @media print{
        table.fixedHeader-floating{
            display:none
        }
    }
</style>
<script>

    $(document).ready(function () {
      
        {if isset($messages.saved)} new Noty({ text: '{brands:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}
        
        {if isset($errors.access_denied)} new Noty({ text: '{brands:errors:0}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)}   new Noty({ text: '{brands:errors:3}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: '{brands:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.article_not_found)} new Noty({ text: '{brands:errors:6}', type: 'error', timeout: 2500 }).show(); {/if}
        
    });
    
    function deleteSuccess(id) {
        new Noty({ text: '{brands:messages:2}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'brand');
    }
    function successImageMessage(){
        new Noty({ text: '{sections:messages:10}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
    }


    $(document).ready(function () {
        {if isset($messages.saved)} $('#savedMessage').click();{/if}
    });



</script>





