<!-- Page header -->
<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<a href="{$adminUrl}/overview" class="btn btn-link btn-float font-size-sm font-weight-semibold text-default legitRipple"><i class="icon-bars-alt text-pink-300"></i><span>Статистика</span></a>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="{$adminUrl}/comments" class="breadcrumb-item">{$title}</a>
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">


			</div>
		</div>
	</div>
</div>
<!-- /page header -->


<!-- Content area -->
<div class="content">
    			
    <div class="row">
    	<div class="col-md-12">
		    <div class="card">
                {include file="stats/form/selectors.tpl" filter=true url="{$adminUrl}/comments" filterDate=true}
		    </div>
		    
            <div class="card">
	            <div class="">
		            <table class="table table-togglable table-striped table-hover" id="comments">
	                    <thead>
	                        <tr>
	                            <th data-hide="ID" class="text-center" width="30">ID</th>
	                            <th data-hide="image" class="text-center">ДАТА</th>
	                            <th data-toggle="true">Одобрен</th>
	                            <th data-hide="phone" class="text-center">Комментарий</th>
	                            <th data-hide="phone, tablet" class="text-center">АВТОР</th>
	                            <th class="text-center text-muted"><i class="icon-checkmark3"></i></th>
	                        </tr>
	                    </thead>
	                    {if $comments}
	                    <tbody class="selectable-demo-list articles_list" id="article_list">

	                        <form action="{$adminUrl}/comments" method="post">
	                            <input type="hidden" name="action" value="bulk">
	                            <input type="hidden" name="query" value="{if isset($query)}{$query}{/if}">
	                            <input type="hidden" name="status" value="{if isset($status)}{$status}{/if}">


	                            {foreach item=comment from=$comments name=comments}
	                            <tr id="comment-{$comment->commentId}">
	                                <td style="line-height: 18px;" class="text-center" nowrap="nowrap">{$comment->commentId}</td>
	                                <td style="line-height: 18px;" nowrap="nowrap">{$comment->addedOn nofilter}</td>
	                                <td style="line-height: 18px;" nowrap="nowrap" class="text-center">{$comment->statusName}</td>
	                                <td style="line-height: 18px;" width="100%">{$comment->content|strip_tags|truncate:100 nofilter}</td>
	                                <td style="line-height: 18px;" width="100%" nowrap="nowrap"> {$comment->authorName|truncate:20} <a href="mailto:{$comment->authorEmail}"> {$comment->authorEmail}</a></td>

	                                <td class="text-center">
	                                    <div class="list-icons">
	                                        <div class="list-icons-item dropdown">
	                                            <a href="#" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown">
	                                                <i class="icon-menu9"></i>
	                                            </a>

	                                            <div class="dropdown-menu dropdown-menu-right">
	                                                <a class="dropdown-item" href="{$adminUrl}/comment?action=edit&id={$comment->commentId}{if isset($page)}&page={$page}{/if}{if isset($query)}&query={$query}{/if}{if isset($status)}&status={$status}{/if}"><i class="icon-pencil7"></i>  {general:edit}</a>
	                                                <div class="dropdown-divider"></div>
	                                                <button class="dropdown-item" name="bulk[{$comment->commentId}]" value="3"><i class="icon-cross2"></i> {general:delete}</button>
	                                            </div>
	                                        </div>
	                                    </div>
	                                </td>
	                            </tr>
	                            {/foreach}
	                        </form>
	                    </tbody>
	                {else}
	                    <tbody><tr class="odd"><td class="data none" colspan="8" align="center">- {general:none} -</td></tr></tbody>
	                    {/if}
	                </table>
	            </div>
                {include file="module/pagination.tpl" url="{$adminUrl}/comments" params="{$buildQueryString}"}
            </div>
            
        
    
     
    	</div>
    
    </div>
</div>    

    {if isset($messages.saved)}<span id="savedMessage" onclick="new Noty({ text: '{comments:messages:0}', type: 'success' }).show();"></span>{/if}
    {if isset($messages.bulk_save)}<span id="bulkSaveMessage" onclick="new Noty({ text: '{comments:messages:2}', type: 'success' }).show();"></span>{/if}
	{if isset($errors.access_denied)}<span id="accessDeniedError" onclick="new Noty({ text: '{comments:errors:0}', type: 'error' }).show();"></span>{/if}
	{if isset($errors.not_saved)}<span id="notSavedError" onclick="new Noty({ text: '{comments:errors:1}', type: 'error' }).show();"></span>{/if}
	{if isset($errors.comment_not_found)}<span id="commentNotFoundError" onclick="new Noty({ text: '{comments:errors:2}', type: 'error' }).show();"></span>{/if}
    <script>
        $(document).ready(function () {
            {if isset($errors.access_denied)} $('#accessDeniedError').click();{/if}
            {if isset($errors.not_saved)} $('#notSavedError').click(); {/if}
            {if isset($errors.comment_not_found)} $('#commentNotFoundError').click();{/if}
      
            {if isset($messages.saved)} $('#savedMessage').click();{/if}
            {if isset($messages.bulk_save)} $('#bulkSaveMessage').click();{/if}
        });
    </script>



