<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<a class="btn btn-sm btn-primary" data-popup="popover-solid" data-trigger="hover" title="{general:add}" data-placement="top" href="{$adminUrl}/currency?action=add"><i class="icon-plus3"></i></a>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="{$adminUrl}/currencies" class="breadcrumb-item">{$title}</a>
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">
				{if $currencyList|count > 0}
				    <a class="breadcrumb-elements-item" href="javascript: void(0);" onclick="showChangeDefaultCurrencyForm();">{currency:setDefaultCurrency}</a>
                {/if}
			</div>
		</div>
	</div>
</div>


<div class="content">
    <div class="row">
    	<div class="col-md-12">
		    <div id="changeDefaultCurrencyRow" style="display:none">
			    <div class="card">
				    <div class="card-body">

                        {if isset($currencyList) && $currencyList|count > 0}
						    <form action="{$adminUrl}/currencies" method="post" onsubmit="return confirmSetDefaultCuttency();">
							    <div class="row justify-content-md-center">
								    <div class="col-md-6">
									    <select class="form-control select" name="id" id="currencyDefaultPretindents" style="width:200px">
                                            {foreach from=$currencyList item=currency}{if $currency.isDefault == 0}
											    <option value="{$currency.id}" label="{$currency.title}">{$currency.title}</option>
                                            {/if}{/foreach}
									    </select>
								    </div>
								    <div class="col-md-3">
									    <button class="btn btn-sm btn-primary" type="submit" name="action" value="setDefaulrCurrency" >{currency:buttons:changeDefaultCurrency}</button>
								    </div>
							    </div>
						    </form>
                        {/if}

				    </div>
			    </div>
		    </div>
            <div class="card">
	            <div class="">
	                <table class="table table-togglable table-xs table-striped table-hover" id="currencys">
                    <thead>
                        <tr>
	                        <th data-hide="ID" class="text-center" width="30">#</th>
	                        <th class="text-left text-nowrap" data-toggle="true">{currency:table:title}</th>
                            <th class="text-center text-nowrap"data-hide="phone">{currency:table:codeName}</th>
                            <th class="text-left text-nowrap"data-hide="phone">{currency:table:course}</th>
                            <th class="text-center text-muted" width="30"><i class="icon-checkmark3"></i></th>
                        </tr>
                    </thead>
                    {if isset($currencyList)}
                    <tbody class="selectable-demo-list currency_list" id="currency_list">
                        {foreach from=$currencyList item=currency}
                        <tr id="currency-{$currency.id}">
	                        <td class="move_zone"><i class="icon-menu8" style="opacity: 0.5"></i> </td>
                            <td class="text-left {if $currency.isDefault}strong{/if}">{$currency.title} {if $currency.isDefault} (<b>{currency:default}</b>){/if}</td>
                            <td class="text-center">{$currency.codeName}</td>
                            <td class="text-left">{$currency.course}</td>
                            <td class="text-left">
                                <div class="list-icons">
	                                <a class="list-icons-item text-primary-600" data-popup="popover-solid" data-trigger="hover" title="{general:edit}" data-placement="top" href="{$adminUrl}/currency?action=edit&id={$currency.id}"><i class="icon-pencil7"></i></a>
    								<div class="list-icons-item dropdown">
    									<a href="#" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>

    									<div class="dropdown-menu dropdown-menu-right">
    										<a class="dropdown-item" href="{$adminUrl}/currency?action=edit&id={$currency.id}"><i class="icon-pencil7"></i>  {general:edit}</a>
    										<div class="dropdown-divider"></div>
    										<a href="javascript:;" class="dropdown-item"  onclick="remove({$currency.id}, '{$currency.title|escape}', 'currencies');"><i class="icon-cross2"></i> {general:delete}</a>
    									</div>
    								</div>
    							</div>
                            </td>
                        </tr>
                        {/foreach}

                    </tbody>

                    {else}
                    <tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                    {/if}
                </table>
	            </div>
            </div>
    	</div>
    </div>
</div>


<script>
    var lang = Array();
	lang['confirmDelete'] = '{currency:messages:confirmDelete}';
	lang['confirmSetDefaultCurrency'] = '{currency:messages:confirmSetDefaultCurrency}'; 

	function deleteCurrency(currencyId, currencyTitle) {

        bootbox.confirm({
            title: lang['confirmDelete'] + ' "' + currencyTitle + '"',
            buttons: {
                cancel: { label: '{general:cancel}', className: 'btn-sm btn-light' },
                confirm: { label: "{general:yes}", className: 'btn-sm  btn-primary' }
            },
            callback: function (response) {
                if (response === true) {
                    window.location.href = window.location.href + '&action=delete&id=' + currencyId;
                }
            }
        });

	}
	
	function showChangeDefaultCurrencyForm() {
        document.getElementById('changeDefaultCurrencyRow').style.display = 'inline';        
    }

	    
    $(document).ready(function () {
        {if isset($messages.saved)} new Noty({ text: '{currency:messages:saved}', type: 'success' }).show(); {/if}
    });

    function deleteSuccess(id) {
        new Noty({ text: '{currency:messages:deleted}', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'currency');
    }

    $("#currency_list").sortable({
        items: "> tr",
        opacity: 0.5,
        revert: true,
        scroll: true,
        tolerance: "pointer",
        handle: ".move_zone",
        scrollSensitivity: 50,
        scrollSpeed: 50,
        cursor: "move",
        connectWith: '.currency_list',
        placeholder	: "ui-sortable-handle",

        update: function(event, ui) {
            $.post( "{$adminUrl}/currencies?action=reorder", $(this).sortable('serialize'), function( data ) {
                location.reload();
            });

        }
    }).disableSelection();

</script>





