<form method="post">

    <div class="page-header page-header-light">
    	<div class="page-header-content header-elements-md-inline">
    		<div class="page-title d-flex">
    			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="d-flex justify-content-center">
                    <button class="btn btn-sm btn-primary legitRipple" type="submit" name="action" value="save" >&nbsp; {general:save} &nbsp;</button>	&nbsp;
                    <a class="btn btn-sm btn-primary legitRipple" href="{$adminUrl}/currencies">{general:cancel}</a>
    			</div>
    		</div>
    	</div>
    
    	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
    		<div class="d-flex">
    			<div class="breadcrumb">
    				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
                    <a href="{$adminUrl}/currencies" class="breadcrumb-item">{$title}</a>
    				<span class="breadcrumb-item currencies">{general:add}</span>
    			</div>
    
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="breadcrumb justify-content-center"></div>
    		</div>
    	</div>
    </div>

    <div class="content">
        <div class="row"> 
            <div class="col-md-12">
    		    <div class="card">
        		    <div class="card-header bg-transparent header-elements-inline">
        				<h6 class="card-title">{general:card:general}</h6>
        				<div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
        			</div>
                    <div class="card-body">
                        <div class="form-group form-group-float">
                            <label class="form-group-float-label is-visible {if isset($errors.titleNull)}text-danger{/if}" >{currency:form:title}</label>
                            <input type="text" class="form-control" name="currency[title]" value="{if isset($currency.title)}{$currency.title}{/if}">
                        </div>
                      

                        <div class="form-group form-group-float">
                            <label class="form-group-float-label is-visible {if isset($errors.titleNull)}text-danger{/if}">{currency:form:codeName}</label>
                            <input type="text" class="form-control" name="currency[codeName]" value="{if isset($currency.codeName)}{$currency.codeName}{/if}" />
                        </div>
                        <div class="form-group form-group-float">
                            <label class="form-group-float-label is-visible {if isset($errors.course)}text-danger{/if}">{currency:form:course}</label>
                            <input  type="text" class="form-control" name="currency[course]" value="{if isset($currency.course)}{$currency.course}{/if}" />
                        </div>
                        <div class="form-group form-group-float">
                            <label class="form-group-float-label is-visible">Отображение копеек</label>
                            <select class="form-control select" name="currency[cent]">
                                <option value="2" {if isset($currency.cent) && $currency.cent == 2}selected{/if}>Да</option>
                                <option value="0" {if isset($currency.cent) && $currency.cent == 0}selected{/if}>Нет</option>
                            </select>
                        </div>
                        <div class="form-group form-group-float">
                            <label class="form-group-float-label is-visible">Разделитель тысяч</label>
                            <select class="form-control select" name="currency[thousands_separator]">
                                <option value=""  {if isset($currency.thousands_separator) && $currency.thousands_separator == ''}selected{/if}>без разделителя: 1245678</option>
                                <option value=" " {if isset($currency.thousands_separator) && $currency.thousands_separator == ' '}selected{/if}>пробел: 1 245 678</option>
                                <option value="," {if isset($currency.thousands_separator) && $currency.thousands_separator == ','}selected{/if}>запятая: 1,245,678</option>
                                <option value="." {if isset($currency.thousands_separator) && $currency.thousands_separator == '.'}selected{/if}>точка: 1.245.678</option>
                            </select>
                        </div>


                    </div>
    		    </div>
    
                <div class="col-md-12 main main_buttons text-center">
                    <button class="btn btn-sm btn-primary" type="submit" name="action" value="save" >&nbsp; {general:save} &nbsp;</button>	&nbsp;
                    <a class="btn btn-sm btn-primary" href="{$adminUrl}/currencies">{general:cancel}</a>
                </div>  
            </div>  
        </div>
    </div>
</form>


<script>
    $(document).ready(function () {
        {if isset($errors.titleNull)} new Noty({ text: '{currency:errors:titleNull}', type: 'error' }).show(); {/if}
        {if isset($errors.codeNameNull)} new Noty({ text: '{currency:errors:codeNameNull}', type: 'error' }).show(); {/if}
        {if isset($errors.course)} new Noty({ text: '{currency:errors:courseNull}', type: 'error' }).show(); {/if}
      
        {if isset($messages.saved)} new Noty({ text: '{currency:messages:saved}', type: 'success' }).show(); {/if}
        {if isset($messages.deleted)} new Noty({ text: '{currency:messages:deleted}', type: 'success' }).show(); {/if}
    });               
</script>
