<!-- Page header -->
<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<a class="btn btn-sm btn-primary" data-popup="popover-solid" data-trigger="hover" title="{general:add}" data-placement="top" href="{$adminUrl}/feature?action=add{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="{$adminUrl}/features" class="breadcrumb-item">{$title}</a>
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">
                {include file="module/show-by.tpl" url="{$adminUrl}/features"}
			</div>
		</div>
	</div>
</div>


<div class="content">
    <div class="row">
    	<div class="col-md-12">
		    <div class="card">
                {include file="stats/form/selectors.tpl" filter=true url="{$adminUrl}/features" filterDate=false}
		    </div>
{*		    <div class="card">*}
{*			    <div class="alert bg-danger text-white alert-dismissible m-0">*}
{*				    <span class="font-weight-semibold">Удалять нельзя!</span>*}
{*			    </div>*}
{*		    </div>*}
            <div class="card">
	            <div class="">
		            <table class="table table-togglable table-xs table-striped table-hover feature-archive" id="features">
		            <thead>
			            <tr>
				            <th data-hide="ID" class="text-center" width="30">{general:table:id}</th>
				            <th data-toggle="true">{general:table:name}</th>
				            <th data-toggle="true">{general:table:section}</th>
				            <th data-hide="phone" >{general:table:status}</th>
				            <th class="text-center text-muted" width="30"><i class="icon-checkmark3"></i></th>
			            </tr>
		            </thead>
                    {if $features}
	                    <tbody class="selectable-demo-list" id="feature_list">
	                    {foreach from=$features item=feature name=features}
				            <tr id="feature-{$feature.id}" class="{if $feature.status eq 'hidden'}table-warning{/if}">
					            <td class="move_zone"><i class="icon-menu8" style="opacity: 0.5"></i> </td>
					            <td class="text-lefttext-nowrap">{$feature.name nofilter}</td>
					            <td class="text-left text-nowrap">{foreach from=$feature.sections item=section}<span class="badge badge-warning">{$section}</span> {/foreach}</td>
					            <td class="text-left" id="status-{$feature.id}">{$feature.statusName}</td>
					            <td class="text-center">
						            <div class="list-icons">
							            <a class="list-icons-item text-primary-600" data-popup="popover-solid" data-trigger="hover" title="{general:edit}" data-placement="top" href="{$adminUrl}/feature?action=edit&id={$feature.id}{$buildQueryString}"><i class="icon-pencil7"></i></a>
							            <div class="list-icons-item dropdown">
								            <a href="#" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>
								            <div class="dropdown-menu dropdown-menu-right">
									            <a class="dropdown-item" href="{$adminUrl}/feature?action=edit&id={$feature.id}{$buildQueryString}"><i class="icon-pencil7"></i> {general:edit}</a>
									            <a href="javascript:void('');" id="article-status-{$feature.id}" class="dropdown-item ajax_action {if $feature.status eq 'visible'}active_class{/if}" data-module="features" data-action="status" data-id="{$feature.id}" name="status" value="1" ><i class="{if $feature.status eq 'visible'}icon-eye{else}icon-eye-blocked{/if}"></i> {general:status}</a>
									            <div class="dropdown-divider"></div>
									            <a href="javascript:void(0);" class="dropdown-item" onclick="remove('{$feature.id}', '{$feature.name|escape nofilter}', 'features');"><i class="icon-cross2"></i> {general:delete}</a>
								            </div>
							            </div>
						            </div>
					            </td>
				            </tr>
                        {/foreach}

			            </tbody>

                        {else}
			            <tbody><tr class="odd"><td class="data none" colspan="8" align="center">- {general:none} -</td></tr></tbody>
                        {/if}
	            </table>
	            </div>
                {include file="module/pagination.tpl" url="{$adminUrl}/features" params="{$buildQueryString}"}
            </div>
    	</div>
    </div>
</div>

	<script>


    $(document).ready(function () {
      
        {if isset($messages.saved)} new Noty({ text: '{articles:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}

        {if isset($errors.not_saved)}   new Noty({ text: '{articles:errors:3}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: '{articles:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.article_not_found)} new Noty({ text: '{articles:errors:6}', type: 'error', timeout: 2500 }).show(); {/if}

    });

    function successImageMessage(){
        new Noty({ text: '{sections:messages:10}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
    }

    function deleteError(){
        new Noty({ text: 'ошибка при удаление контента', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }

    function deleteSuccess(id) {
        new Noty({ text: '{articles:messages:2}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
        removeElement(id, 'feature');
    }

    function notFound(){
        new Noty({ text: 'контент не найден или пустой ID', layout: 'topRight', type: 'error', timeout: 1500 }).show();
    }
    function approveError(){
        new Noty({ text: 'ошибка при одобрение контента', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }
    function statusError() {
        new Noty({ text: 'ошибка при изменение статуса контента', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }


    $("#feature_list").sortable({
        items: "> tr",
        opacity: 0.5,
        revert: true,
        scroll: true,
        tolerance: "pointer",
        handle: ".move_zone",
        scrollSensitivity: 50,
        scrollSpeed: 50,
        cursor: "move",
        connectWith: '.feature_list',
        placeholder	: "ui-sortable-handle",

        update: function(event, ui) {
	        $.post( "{$adminUrl}/features?action=reorder", $(this).sortable('serialize'), function( data ) {
                // location.reload();
            });
        }
    }).disableSelection();



</script>



