

    <div class="page-header page-header-light">
    	<div class="page-header-content header-elements-md-inline">
    		<div class="page-title d-flex">
    			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="d-flex justify-content-center">
                    {if !isset($action)}
	                    <a class="btn btn-sm btn-primary mx-1" data-popup="popover-solid" data-trigger="hover" title="{general:add} группу" data-placement="top" href="{$adminUrl}/managergroups?action=edit{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>
                    {/if}
			    </div>
    		</div>
    	</div>
    
    	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
    		<div class="d-flex">
    			<div class="breadcrumb">
                    <a href="{$adminUrl}/managergroups" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> {$title}</a>
    			</div>
    
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="breadcrumb justify-content-center">
                    {if !isset($action)}
                    {include file="module/show-by.tpl" url="{$adminUrl}/users"}
                    {/if}
    			</div>
    		</div>
    	</div>
    </div>

{if isset($action) && $action eq 'edit'}

    <!-- Content area -->
    <div class="content">
	    <form  method="post" enctype="multipart/form-data" id="manager">
        <div class="row">
	        <div class="col-md-12">
		        <div class="card collapse" id="collapse-notice">
			        <div class="card-header bg-transparent header-elements-inline">
				        <h6 class="card-title">Заметки</h6>
			        </div>
			        <div class="card-body">
				        <textarea class="form-control p-2" style="width:100%;height:200px;" readonly>{if isset($manager->notice)}{$manager->notice nofilter}{/if}</textarea>
			        </div>
		        </div>
	        </div>

            <div class="col-md-12">
    		    <div class="card">
        		    <div class="card-header bg-transparent header-elements-inline">
        				<h6 class="card-title">{general:tabs:general}</h6>
        				<div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
        			</div>
                    <div class="card-body">
        			    <div class="row">
            			    <div class="col-md-6">
                                <div class="form-group form-group-float">
                                    <label for="groupName" class="form-group-float-label is-visible {if isset($errors.name_empty) || isset($errors.name_exists)}text-danger{/if}">Группа</label>
                                    <input type="text" class="form-control" autocomplete="off" id="groupName" name="group[groupName]" value="{if isset($manager.groupName)}{$manager.groupName}{/if}" />
                                </div>
            			    </div>

                            <div class="col-md-6">
	                            <div class="form-group form-group-float">
		                            <label for="status" class="form-group-float-label is-visible">{general:status}</label>
                                    {html_options options=$statuses name="group[status]" selected=$manager.status|default:'visible' id="status" class="form-control select"}
	                            </div>
                            </div>
                        </div> 
                    </div>
    		    </div>
            </div>
            {* права доступа *}
	        <div class="col-md-12">
		        <div class="alert bg-info text-white alert-styled-left alert-dismissible">
			        <span class="font-weight-semibold">Указать привилегии к пунктам меню</span> которые будут отображаться только для этой группы пользователей, с ограничениями доступа к другим пунктам меню.
		        </div>
		        <div class="card">
			        <div class="card-header bg-transparent header-elements-inline">
				        <h6 class="card-title {if isset($errors.privileges_empty)}text-danger{/if}">Настроить привилегии для этой группы пользователей</h6>
				        <div class="header-elements">
					        <div class="list-icons">
						        <div class="custom-control custom-checkbox check_block_box mt-2 mr-3">
							        <input type="checkbox" class="custom-control-input all_perms" id="all_perms" value="" data-fouc>
							        <label class="custom-control-label " for="all_perms">Все пункты меню</label>
						        </div>
						        <a class="list-icons-item" data-action="collapse"></a>
					        </div>
				        </div>
			        </div>
			        <div class="card-body flex-column flex-md-row">
				        <div class="boxed fn_toggle_wrap">
			                {* права доступа *}
                            {strip}
						        <div class="toggle_body_wrap on fn_card">
                                    {foreach $permission as $title => $items}
								        <div class="card-body bg-light permission_block mb-2">
									        <div class="heading_box"><h6 class="font-weight-semibold">{$items.name}</h6></div>
									        <div class="permission_boxes row fn_perms_wrap">
                                                {foreach $items.children as $key => $item}
											        <div class="col-xl-2 col-lg-3 col-md-6 mb-3">
												        <div class="permission_box">
													        <div class="custom-control custom-checkbox check_block_box text-muted">
														        <input type="checkbox" class="custom-control-input item_perm" id="{$item.fileName}_{$key}" name="privileges[]"
														               value="{$item.fileName}" {if isset($manager.privilege) &&  in_array($item.fileName, $manager.privilege)}checked{/if} data-fouc>
														        <label class="custom-control-label" for="{$item.fileName}_{$key}">{$item.name|escape}</label>
													        </div>
												        </div>
											        </div>
                                                {/foreach}
									        </div>
								        </div>
                                    {/foreach}
						        </div>
                            {/strip}
				        </div>
			        </div>
		        </div>


		        <div class="col-md-12 main main_buttons text-center">
			        <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="save"><i class="icon-floppy-disk mr-2"></i> {general:save}</button>
			        <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="apply"><i class="icon-checkmark3 mr-2"></i> {general:apply}</button>
			        <a class="btn btn-sm btn-light" href="{$adminUrl}/managergroups">{general:cancel}</a>
		        </div>
	        </div>
        </div>
	    </form>
    </div>
{else}
	<!-- Content area -->
	<div class="content">

		<div class="row">
			<div class="col-md-12">

				<div class="card">
					<div class="">
						<table class="table table-togglable table-xs table-striped table-hover users-archive" id="groups">
							<thead>
							<tr>
								<th data-hide="image" class="">Группа</th>
								<th data-hide="phone" class="text-center">{general:status}</th>
								<th class="text-center text-muted" width="30"><i class="icon-checkmark3"></i></th>
							</tr>
							</thead>
                            {if isset($groups)}
								<tbody>
                                {foreach item=group from=$groups name=groups}
									<tr id="group-{$group.groupId}">
										<td class="">{$group.groupName nofilter}</td>
										<td id="status-{$group.groupId}" class="text-center">{$group.statusName nofilter}</td>
										<td class="text-left">
											<div class="list-icons">
												<a class="list-icons-item text-primary-600" data-popup="popover-solid" data-trigger="hover" title="{general:edit}" data-placement="top" href="{$adminUrl}/managergroups?action=edit&id={$group.groupId}{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-pencil7"></i></a>
                                                {if !$smarty.foreach.groups.first}
												<div class="list-icons-item dropdown">
													<a href="javascript:void('');" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>

													<div class="dropdown-menu dropdown-menu-right">
														<a class="dropdown-item" href="{$adminUrl}/managergroups?action=edit&id={$group.groupId}&page={$page}{$buildQueryString}"><i class="icon-pencil7"></i> {general:edit}</a>
														<a href="javascript:void('');" id="article-status-{$group.groupId}" class="dropdown-item ajax_action {if $group.status eq 'visible'}active_class{/if}" data-module="managergroups" data-action="status" data-id="{$group.groupId}" name="status" value="1" ><i class="{if $group.status eq 'visible'}icon-eye{else}icon-eye-blocked{/if}"></i> {general:status}</a>
														<div class="dropdown-divider"></div>
														<a href="javascript:void('');" class="dropdown-item"  onclick="remove({$group.groupId}, '{$group.groupName}', 'managergroups')"><i class="icon-cross2"></i> {general:delete}</a>
													</div>
												</div>
												{/if}
											</div>
										</td>
									</tr>
                                {/foreach}

								</tbody>
                            {else}
								<tbody><tr class="odd"><td class="data none" colspan="8" align="center">- {general:none} -</td></tr></tbody>
                            {/if}
						</table>
					</div>
                    {include file="module/pagination.tpl" url="{$adminUrl}/managergroups" params="{$buildQueryString}"}

				</div>
			</div>

		</div>
	</div>
{/if}


{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>
	$(document).ready(function () {

	    {if isset($errors.name_empty)}     new Noty({ text: '{managers:errors:13}', type: 'error' }).show(); {/if}
	    {if isset($errors.name_exists)}    new Noty({ text: '{managers:errors:0}', type: 'error' }).show(); {/if}
	    {if isset($errors.user_not_found)}  new Noty({ text: '{managers:errors:1}', type: 'error' }).show();  {/if}

	    {if isset($errors.not_saved)}       new Noty({ text: '{managers:errors:5}', type: 'error' }).show(); {/if}

	    {if isset($errors.privileges_empty)} new Noty({ text: 'У группы пользователей должна быть хотя бы одна привилегия.', type: 'error' }).show(); {/if}

	    {if isset($messages.saved)} new Noty({ text: '{managers:messages:0}', type: 'success' }).show(); {/if}
	});

	function deleteSuccess(id) {
	    new Noty({ text: 'Группа удалена', type: 'success', timeout: 1500 }).show();
	    removeElement(id, 'group');
	}
	function deleteError() {
	    new Noty({ text: 'Группа не удалена', type: 'error', timeout: 1500 }).show();
	}

    $(document).on("change", ".all_perms", function () {
          if($(this).is(":checked")) {
              $('.item_perm').each(function () {
                  if(!$(this).is(":checked")) {
                      $(this).trigger("click");
                      // console.log($(this).attr('id'))
                  }
              });
          } else {
              $('.item_perm').each(function () {
                  if($(this).is(":checked")) {
                      $(this).trigger("click");
                      // console.log($(this).attr('id'))
                  }
              })
          }
    });
	$(document).on("change", ".item_perm", function () {
	    var id = $(this).attr('id');
        console.log(id);
        if ($(this).is(":checked")) {
            $('#parent_'+id).prop('checked', true);
        } else {
            $('#parent_'+id).prop('checked', false);
        }

	});
</script>
