<form action="{$adminUrl}/maps" method="post" id="map" autocomplete="off" style="display: contents;">
    <div class="page-header page-header-light">
    	<div class="page-header-content header-elements-md-inline">
    		<div class="page-title d-flex">
    			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="d-flex justify-content-center">
                    <button class="btn btn-sm btn-primary" type="submit" name="action" value="save" >&nbsp; {general:save} &nbsp;</button>	&nbsp;
    			</div>
    		</div>
    	</div>
    
    	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
    		<div class="d-flex">
    			<div class="breadcrumb">
    				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
                    <a href="{$adminUrl}/maps" class="breadcrumb-item">{$title} карты</a>
    			</div>
    
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="breadcrumb justify-content-center">
    			</div>
    		</div>
    	</div>
    </div>
    <!-- /page header -->
    
    
    <!-- Content area -->
    <div class="content">
        <div class="row"> 
            <div class="col-md-6">
    		    <div class="card">
        		    <div class="card-header bg-transparent header-elements-inline">
        				<h6 class="card-title">{general:card:general}</h6>
        				<div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
        			</div>
                    <div class="card-body">
        			    <div class="row">
				            <div class="col-md-6">
					            <div class="form-group form-group-float">
						            <label class="form-group-float-label is-visible">{if isset($map.isMaps) and $map.isMaps eq 1}{settings:map:mapOff}{else}{settings:map:mapOn}{/if}</label>
                                    {html_options options=$works name="map[isMaps]" id="isMaps" selected=$map.isMaps|default:0 class="form-control select"}
					            </div>
				            </div>
				            <div class="col-md-6">
					            <div class="form-group form-group-float">
						            <label class="form-group-float-label is-visible">{settings:map:mapType}</label>
						            <select class="form-control select" name="map[type]">
							            <option value="">Выбрать тип карты</option>
							            <option value="yandex" {if isset($map.type) AND $map.type eq 'yandex'}selected{/if}>Yandex карта</option>
							            <option value="google" {if isset($map.type) AND $map.type eq 'google'}selected{/if}>Google карта</option>
						            </select>
					            </div>
				            </div>
				            <div class="col-md-6">
					            <div class="form-group form-group-float">
						            <label class="form-group-float-label is-visible {if isset($errors.languageName)}text-danger{/if}">{settings:map:mapApi}</label>
						            <input type="text" class="form-control" name="map[api_key]" value="{if isset($map.api_key)}{$map.api_key}{/if}">
					            </div>
				            </div>
            			    <div class="col-md-6">
                                 <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible">{settings:map:coordinates}</label>
                                    <input type="text" class="form-control" name="map[coordinates]" value="{if isset($map.coordinates)}{$map.coordinates}{/if}">
                                </div>
            			    </div>
            			    
                            <div class="col-md-4">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible">{settings:map:zoomMap}</label>
                                    <input type="text" class="form-control" name="map[zoom]" value="{if isset($map.zoom)}{$map.zoom}{/if}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group form-group-float">
                                    <label class="field_name">{settings:map:heightMap}</label>
                                    <input type="text" class="form-control" name="map[maps_height]" value="{if isset($map.maps_height)}{$map.maps_height}{/if}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible">{settings:map:wightMap}</label>
                                    <input type="text" class="form-control" name="map[maps_wight]" value="{if isset($map.maps_wight)}{$map.maps_wight}{/if}">
                                </div>
            			    </div>
                            <div class="col-md-4">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible">{settings:map:scale}</label>
                                    <input type="text" class="form-control" name="map[scale]" value="{if isset($map.scale)}{$map.scale}{/if}">
                                </div>
                            </div>
                           <div class="col-md-4">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible">{settings:map:fillColor}</label>
                                    <input type="text" class="form-control" name="map[fillColor]" value="{if isset($map.fillColor)}{$map.fillColor}{/if}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible">{settings:map:fillOpacity} </label>
                                    <input type="text" class="form-control" name="map[fillOpacity]" value="{if isset($map.fillOpacity)}{$map.fillOpacity}{/if}">
                                </div>
                            </div>
                        </div> 
                    </div>
    		    </div>
            </div>

            <div class="col-md-6">
        		<div class="card">	
                    <div class="card-header bg-transparent header-elements-inline">
                        <h6 class="card-title">{general:card:map}</h6>
    					<div class="header-elements">
    						<div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div>
                		</div>
    				</div>
			        {if isset($map.isMaps) and $map.isMaps eq 1}
				        <div class="block_maps"><div id="map-canvas"></div></div>
			        {/if}
    			</div>
            </div>
	        <div class="col-md-12">
		        <div class="col-md-12 main main_buttons text-center">
			        <button class="btn btn-sm btn-primary" type="submit" name="action" value="save" >&nbsp; {general:save} &nbsp;</button>	&nbsp;
		        </div>
	        </div>
        </div>
    </div>

</form>

<script>
    $(document).ready(function() {
        {if isset($messages.saved)}
            new Noty({ text: '{settings:messages:0}', type: 'success', timeout: 1500 }).show();
	    {/if}
    }); 
</script>

    
{if isset($map.isMaps) and $map.isMaps eq 1}
	{if isset($map.type) and $map.type eq 'google'}
		{google_maps}
	{elseif isset($map.type) and $map.type eq 'yandex'}
	    {yandex_maps}
	{/if}
{/if}