<form method="post" enctype="multipart/form-data">
    <div class="page-header page-header-light">
    	<div class="page-header-content header-elements-md-inline">
    		<div class="page-title d-flex">
    			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="d-flex justify-content-center">
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="save"><i class="icon-floppy-disk mr-2"></i> {general:save}</button>
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="apply"><i class="icon-checkmark3 mr-2"></i> {general:apply}</button>&nbsp;&nbsp;
                    <a class="btn btn-sm btn-light" href="{$adminUrl}/news?page={if isset($page)}{$page}{/if}{$buildQueryString}">{general:cancel}</a>
    			</div>
    		</div>
    	</div>
    
    	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
    		<div class="d-flex">
    			<div class="breadcrumb">
    				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
                    <a href="{$adminUrl}/news" class="breadcrumb-item">{$title}</a>
    				<span class="breadcrumb-item active">{general:add}</span>
    			</div>
    
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="breadcrumb justify-content-center"></div>
    		</div>
    	</div>
    </div>
    <!-- /page header -->
    
    
    <!-- Content area -->
    <div class="content">
    
        <div class="row"> 
            <div class="col-md-8">
    
    		    <div class="card">
        		    <div class="card-header bg-transparent header-elements-inline">
        				<h6 class="card-title">{general:card:general}</h6>
        				<div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
        			</div>
                    <div class="card-body">
        			
        			    <div class="row">
                            <div class="col-md-6">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible {if isset($errors.sectionId)}text-danger{/if}">{general:section}</label>
                                    {html_options options=$sections name="article[sectionId]" id="sectionId" selected=$article.sectionId|default:'' class="form-control select"}
                                </div>
                            </div>

            			    <div class="col-md-6">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible {if isset($errors.title)}text-danger{/if}">{general:title}</label>
                                    <input type="text" class="form-control" id="title" autocomplete="off" name="article[title]" value="{if isset($article.title)}{$article.title}{/if}" onblur="proposeFileName('title', 'fileName', 'article', '{$config.filename_word_separator}', '{$config.convert_filename_to_lowercase}');">
                                </div>
            			    </div>
                            <div class="col-md-6">
                                <div class="form-group form-group-float">
                                    <label class="form-group-float-label is-visible {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">{general:filename}</label>
                                    <input  type="text" class="form-control" id="fileName" autocomplete="off" name="article[fileName]" value="{if isset($article.fileName)}{$article.fileName}{/if}" />
                                </div>
            			    </div>
				            <div class="col-md-6">
					            <div class="form-group form-group-float">
						            <label class="form-group-float-label is-visible ">{general:alias}</label>
						            <input  type="text" class="form-control" id="alias" autocomplete="off" name="article[alias]" value="{if isset($article.alias)}{$article.alias}{/if}" />
					            </div>
				            </div>
                        </div> 
                    </div>
    		    </div>

                <div class="card collapse {if isset($article.enableGallery) and $article.enableGallery eq 1}show{/if}" id="gallery-card">
                    <div class="card-header bg-transparent header-elements-inline">
                        <h6 class="card-title">Фотогалерея</h6>
                        <div class="header-elements"><div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div></div>
                    </div>
                    <div class="card-body">
                        <div class="row gallery gallery-product gallery-sortable mt-2" id="fileList">
                            {if isset($article.gallery)}
                                {foreach item=file from=$article.gallery}
		                            <figure class="gallery-item mb-0" id="gallery-item-{$file->imageId}" data-id="{$file->imageId}">
			                            <div class="move_zone image">
				                            <img src="{$file->medium}" alt="{if isset($file->title)}{$file->title}{/if}"/>
				                            <ul class="gallery-item-controls">
					                            <li><span>{$file->orderBy}</span></li>
					                            <li>
                                                    <span class="edit_image" id="edit_image_{$file->imageId}"
                                                          data-title="{$file->title}"
                                                          data-alias="{$file->alias}"
                                                          data-description="{$file->description}"
                                                          data-link="{$file->link}"
                                                          data-position="{$file->position}"
                                                          onclick="editPictureInfo({$file->imageId}, 'Добавить описание к картинке', 'new');"><i class="icon-quill4"></i></span>
					                            </li>
					                            <li>
						                            <span onclick="deletePicture({$file->imageId}, 'new');"><i class="icon-cross2"></i></span>
					                            </li>
				                            </ul>
			                            </div>
			                            <div class="meta" id="meta_image_{$file->imageId}" style="padding: 0;">
				                            <span id="im_title" class="font-weight-semibold">{$file->title}</span>
				                            <span id="im_alias" class="font-weight-semibold">{$file->alias}</span>
				                            <span id="im_description">{$file->description nofilter}</span>
				                            <span id="im_link">{$file->link}</span>
				                            <span id="im_position" class="badge badge-primary" style="color: #fff;">{$file->position}</span>
			                            </div>
		                            </figure>
                                {/foreach}
                            {/if}
                        </div>
                    </div>
                    <div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
                        <a class="btn btn-sm btn-primary btn-upload read-more" href="javascript:void('')"
                           data-type="gallery"
                           data-path="/"
                           data-action="read_more"
                           data-module="files"
                        ><i class="icon-images2 mr-2"></i> {general:uploadFiles} </a>
                        <a class="btn btn-sm btn-primary btn-sorting collapse" href="javascript:void('')"
                           data-action="sortPictures"
                           data-module="article"
                        ><i class="icon-checkmark3 mr-2"></i> {general:apply}</a>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header bg-transparent header-elements-inline">
    				    <h6 class="card-title">Описание</h6>
                        <div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
    			    </div>

                    <div class="card-body flex-column flex-md-row m-0  p-0">
        			    <ul class="nav nav-tabs nav-tabs-top mb-0" style="border-bottom: 0px solid #ddd;">
        				    <li class="nav-item"><a href="#summary" class="nav-link active show" data-toggle="tab">{general:tabs:summary}</a></li>
                            <li class="nav-item"><a href="#content" class="nav-link" data-toggle="tab">{general:tabs:content}</a></li>
        			    </ul>
        
                        <div class="tab-content border-top-0 rounded-top-0 mb-0">
        				    <div class="tab-pane fade show active" id="summary">
        					    <textarea name="article[summary]" class="description">{if isset($article.summary)}{$article.summary}{/if}</textarea>
        				    </div>
        
                            <div class="tab-pane fade" id="content">
        					    <textarea name="article[content]" class="description">{if isset($article.content)}{$article.content}{/if}</textarea>
        				    </div>
        				</div>
    			    </div>
    		    </div>
    
    
                <div class="col-md-12 main main_buttons text-center">
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="save"><i class="icon-floppy-disk mr-2"></i> {general:save}</button>
                    <button class="btn btn-sm btn-primary mr-2" type="submit" name="action" value="apply"><i class="icon-checkmark3 mr-2"></i> {general:apply}</button>	&nbsp;	&nbsp;
                    <a class="btn btn-sm btn-light" href="{$adminUrl}/news&page={if isset($page)}{$page}{/if}{$buildQueryString}">{general:cancel}</a>
                </div>
            
            </div>
    
    
            <div class="col-md-4">
        		<div class="card">
                    <div class="card-header bg-transparent header-elements-inline">
                        <h6 class="card-title">{general:card:statusAndVisibility}</h6>
    					<div class="header-elements">
    						<div class="list-icons">
    	                		<a class="list-icons-item" data-action="collapse"></a>
                    		</div>
                		</div>
    				</div>
    				<div class="card-body border-top-0">
                        <figure>
                            <div class="form-group form-group-float">
                                <label class="form-group-float-label is-visible">{general:status}</label>
                                {html_options options=$statuses name="article[status]" id="status" selected=$article.status|default:'' class="form-control select"}
                            </div>
                        </figure>

					    <figure>
						    <div class="form-group form-group-float">
							    <label class="form-group-float-label is-visible">Тип ссылки <br /><i><code>если нужно открывать (Модальное окно) укажите этот тип, если нужно чтоб переходило на <b>сторонний сайт</b> или перейти на какую то <b>другую страницу</b>, укажите (Внешняя ссылка) и <b>обязательно прописать ссылку</b></code></i></label>
                                {html_options options=$urlTypes selected=$article.urlType|default:'' name="article[urlType]" class="form-control select selectUrlType" id="selectUrlType"}

						    </div>
						    <div class="form-group form-group-float collapse {if !empty($article.urlType) AND $article.urlType eq 'external'}show{/if}" id="icon-urlType">
							    <label class="form-group-float-label is-visible  {if isset($errors.externalLink)}text-danger{/if}">Ссылка <code>(t.me/@life)</code></label>
							    <input type="text" class="form-control" id="link" name="article[externalLink]" value="{if isset($article.externalLink)}{$article.externalLink}{/if}"/>
						    </div>
					    </figure>

                        <figure>
                            <div class="form-check">
                                <label class="form-check-label">
                                    <input type="checkbox" class="form-check-input-styled" name="article[enableGallery]" data-fouc="" value="1"
                                           {if isset($article.enableGallery) and $article.enableGallery eq 1}checked{/if}
                                           data-toggle="collapse"
                                           data-target="#gallery-card"
                                           aria-expanded="{if isset($article.enableGallery) and $article.enableGallery eq 1}true{else}false{/if}"
                                    >
                                    Фотогалерея к этой публикации
                                </label>
                            </div>
                        </figure>

                        <figure>
                            <div class="form-group">
                                <label class="form-group-float-label is-visible">{articles:misc:publishDate}</label>
	                            <div class="row">
		                            <div class="col-md-12">
			                            <div class="input-group">
											<span class="input-group-prepend">
												<span class="input-group-text"><i class="icon-calendar3"></i></span>
											</span>
				                            <input type="text" class="form-control daterange-single" name="article[publishedOn]" value="{$article.publishedOn|default:$adjustedNow}" readonly>
			                            </div>
		                            </div>
	                            </div>
                            </div>
                        </figure>

                        <figure>
                            <div class="form-group form-group-float">
                                <label class="form-group-float-label is-visible">{articles:misc:featured}</label>
                                <select name="article[isFeatured]" class="form-control select">
                                    <option value="0" {if isset($article.isFeatured) and $article.isFeatured eq 0} selected{/if}>{general:no}</option>
                                    <option value="1" {if isset($article.isFeatured) and $article.isFeatured eq 1} selected{/if}>{general:yes}</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label class="form-group-float-label is-visible">{general:comments}</label>
                                <select name="article[commentsEnabled]" class="form-control select">
                                    <option value="0" {if isset($article.commentsEnabled) and $article.commentsEnabled == 0} selected{/if}>{general:defaultComments}</option>
                                    <option value="-1" {if isset($article.commentsEnabled) and $article.commentsEnabled == -1} selected{/if}>{general:disableComments}</option>
                                    <option value="1" {if isset($article.commentsEnabled) and $article.commentsEnabled == 1} selected{/if}>{general:enableComments}</option>
                                </select>
                            </div>
                        </figure>
                        <figure>
                            {if isset($article.addedOn)}
                                <div class="d-sm-flex flex-sm-wrap">
                                    <div class="font-weight-semibold">{general:created}</div>
                                    <div class="ml-sm-auto mt-2 mt-sm-0">{$article.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$article.addedBy->loginName|default:"{general:unknowUser}"})</div>
                                </div>
                            {/if}
                            {if isset($article.modifiedOn)}
                            <div class="d-sm-flex flex-sm-wrap">
                                <div class="font-weight-semibold">{general:modified}</div>
                                <div class="ml-sm-auto mt-2 mt-sm-0">{$article.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$article.modifiedBy->loginName|default:"{general:unknowUser}"})</div>
                            </div>
                            {/if}
                        </figure>
                        
    				</div>
    			</div>
                {if isset($brands)}
		            <div class="card">
			            <div class="card-header bg-transparent header-elements-inline">
				            <h6 class="card-title {if isset($errors.brand)}text-danger{/if}">{general:card:brand}</h6>
				            <div class="header-elements">
					            <div class="list-icons"><a class="list-icons-item" data-action="collapse"></a></div>
				            </div>
			            </div>


			            <div class="card-body">
				            <div class="form-group form-group-float">
					            <select name="article[brand]" class="form-control select  select-search">
						            <option value="">Выбрать бренд</option>
                                    {foreach item=brandList from=$brands name=brands key=$key}
							            <optgroup label="{$key|upper}">
                                            {foreach from=$brandList item=brand}
									            <option value="{$brand->fileName}" {if isset($article.brand) and $article.brand eq $brand->fileName}selected{/if}>{$brand->name}</option>
                                            {/foreach}
							            </optgroup>
                                    {/foreach}
					            </select>
				            </div>
			            </div>
		            </div>
                {/if}

                <div class="card">
                    <div class="card-header bg-transparent header-elements-inline">
                        <h6 class="card-title">{general:card:addImage}</h6>
                        <div class="header-elements">
                            <div class="list-icons">
                                <a class="list-icons-item" data-action="collapse"></a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="content-image gallery">
                            {if isset($article.image)}
                                <div class="gallery-item item-{$article.image->imageId}" id="image_general">
                                    <div class="image" id="image-{$article.image->imageId}">
                                        <img src="{$article.image->medium}" />
                                        <ul class="gallery-item-controls">
                                            <li><span onclick="deleteImage({$article.image->imageId}, 'new');"><i class="icon-cross2"></i></span></li>
                                        </ul>
                                    </div>
                                </div>
                            {/if}
                        </div>
                    </div>
                    <div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
                        <a class="btn btn-sm btn-primary btn-upload read-more" href="javascript:void('')"
                           data-type="image"
                           data-path="/"
                           data-action="read_more"
                           data-module="files"
                        ><i class="icon-image2 mr-2"></i> {general:uploadFile} </a>
                    </div>

                </div>
    
    			<div class="card card-collapsed">
    			    <div class="card-header bg-transparent header-elements-inline">
    				    <h6 class="card-title">{general:tabs:seo}</h6>
                        <div class="header-elements">
    						<div class="list-icons">
							    <ul class="list-inline mb-0">
								    <li class="list-inline-item"><button type="button" class="btn btn-outline-primary border-transparent" onclick="auto_keywords();">Сгенерировать ключевые слова</button></li>
								    <li class="list-inline-item"><a class="list-icons-item" data-action="collapse"></a></li>
							    </ul>
                    		</div>
                		</div>
    			    </div>
    
        			<div class="card-body flex-column flex-md-row m-0">
        				<div class="form-group form-group-float">
                            <label class="form-group-float-label is-visible">{general:metaTitle}</label>
                            <input class="form-control" autocomplete="off" id="meta_title" type="text" name="article[meta_title]" value="{if isset($article.meta_title)}{$article.meta_title}{/if}"/>
                        </div>
				        <div class="form-group">
					        <label class="form-group-float-label is-visible">{general:keywords}</label>
					        <div class="input-group">
						        <input type="text" class="form-control tokenfield-primary" id="keywords" name="article[keywords]" value="{if isset($article.keywords)}{$article.keywords}{/if}" data-fouc>
					        </div>
				        </div>
                        <div class="form-group">
                            <label class="form-group-float-label is-visible">{general:description}</label>
                            <textarea id="description" name="article[description]" class="form-control" rows="3">{if isset($article.description)}{$article.description}{/if}</textarea>
                        </div>
        			</div>
        		</div>
    
            </div>
    
        </div>

    </div>

</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}
{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>

    $(document).ready(function () {
    
        {if isset($errors.access_denied)} new Noty({ text: '{news:errors:0}', type: 'error', timeout: 1500 }).show(); {/if}
        {if isset($errors.title)} new Noty({ text: '{news:errors:1}', type: 'error', timeout: 1500 }).show(); {/if}
        {if isset($errors.sectionId)} new Noty({ text: '{news:errors:2}', type: 'error', timeout: 1500 }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: '{news:errors:3}', type: 'error', timeout: 1500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: '{news:errors:4}', type: 'error', timeout: 1500 }).show(); {/if}
        {if isset($errors.image_not_saved)} new Noty({ text: '{news:errors:5}', type: 'error', timeout: 1500 }).show(); {/if}
        {if isset($errors.article_not_found)} new Noty({ text: '{news:errors:6}', type: 'error', timeout: 1500 }).show(); {/if}
        {if isset($errors.fileName)} new Noty({ text: '{news:errors:7}', type: 'error', timeout: 1500 }).show();{/if}
        {if isset($errors.fileNameExists)} new Noty({ text: '{news:errors:8}', type: 'error', timeout: 1500 }).show(); {/if}
        {if isset($errors.htaccess)} new Noty({ text: '{news:errors:9}', type: 'error', timeout: 1500 }).show(); {/if}
        {if isset($errors.serializations)} new Noty({ text: '{news:errors:10}', type: 'error', timeout: 1500 }).show(); {/if}
        {if isset($errors.fileNameProhibited)} new Noty({ text: '{news:errors:11}', type: 'error', timeout: 1500 }).show();{/if}
        {if isset($errors.fileNameCharacters)} new Noty({ text: '{news:errors:12}', type: 'error', timeout: 1500 }).show(); {/if}

        {if isset($errors.typeNews)} new Noty({ text: 'Необходимо указать тип новости', type: 'error', timeout: 1500 }).show(); {/if}

        {if isset($messages.saved)} new Noty({ text: '{news:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}

    });


    function successSortImageMessage(){
        new Noty({ text: 'Порядковый номер изменен', type: 'success', timeout: 1500 }).show();
    }

    $(document).ready(function(){
        // сортировка галереи
        $("#fileList").sortable({
            items: "> figure.gallery-item",
            opacity: 0.5,
            revert: true,
            scroll: true,
            tolerance: "pointer",
            handle: ".move_zone",
            cursor: "move",
            scrollSensitivity: 50,
            scrollSpeed: 50,
            forcePlaceholderSize: true,
            connectWith: '.gallery-product',
            placeholder: "gallery-sortable",
            stop : function () {
                $('.btn-sorting').addClass('show');
            }
        }).disableSelection();
        // применить сортировку галереи
        $(document).on("click", ".btn-sorting" , function() {
            var module = $(this).attr('data-module'), action = $(this).attr('data-action');
            var ids = new Array();
            $('#fileList figure.gallery-item').each(function() {
                ids.push($(this).attr("data-id"));
            });

            $.ajax({
                url: "{$adminUrl}/"+module,
                method: "POST",
                data: {
                    imageIds: ids,
                    action: action
                },
                success: function (data) {
                    console.log(data)
                    $("#fileList").load(location.href + " figure.gallery-item");
                    new Noty({ text: 'Фотогалерея отсортирована', type: 'success' }).show();
                    $('.btn-sorting').removeClass('show');
                }
            });
        });

        $('#selectUrlType').change(function(){
            console.log($('#selectUrlType').val())
            if($('#selectUrlType').val() === 'external') {
                if (!$("#icon-urlType").hasClass("show"))
                    $('#icon-urlType').addClass("show");
            } else {
                if ($("#icon-urlType").hasClass("show"))
                    $('#icon-urlType').removeClass("show");

            }
        });
    });
        
        
    </script>
