<!-- Page header -->
<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<a href="{$adminUrl}/overview" class="btn btn-link btn-float font-size-sm font-weight-semibold text-default legitRipple"><i class="icon-bars-alt text-pink-300"></i><span>Статистика</span></a>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="{$adminUrl}/news" class="breadcrumb-item">{$title}</a>
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">
				{if !empty($sections)}
				<a class="breadcrumb-elements-item" href="{$adminUrl}/new?action=add{if isset($page)}&page={$page}{/if}{$buildQueryString}" title="{general:add}"><i class="icon-plus3"></i> {general:add}</a>
				{/if}
			</div>
		</div>
	</div>
</div>
<!-- /page header -->


<!-- Content area -->
<div class="content">
    			
    <div class="row">
    	<div class="col-md-12">
            {if empty($sections)}
			    <div class="card">
				    <div class="alert bg-danger text-white alert-dismissible m-0">
					    <span class="font-weight-semibold">Перед добавлением новостей, добавьте хотя бы один <a href="{$adminUrl}/section?action=add&parentId=0" class="text-white">раздел</a> c типом новости.</span>
				    </div>
			    </div>
		    {/if}
		    <div class="card">
                {include file="module/filter-content.tpl" url="{$adminUrl}/news"}
		    </div>
            <div class="card">
	            <div class="">
                <table class="table table-xs table-togglable table-striped table-hover" id="articles">
                    <thead>
                        <tr>
                            <th data-hide="ID" class="text-center" width="30">{general:table:id}</th>
                             <th data-hide="phone" class="text-center" width="30">{general:table:date}</th>
                            <th data-hide="image" class="text-center">{general:table:image}</th>
                            <th data-toggle="true">{general:table:product}</th>
                            <th data-hide="phone" class="text-center">{general:table:section}</th>
                            <th data-hide="phone" class="text-center">Тип</th>
                            <th data-hide="phone, tablet" class="text-center">{general:table:favorites}</th>
                            <th data-hide="phone" class="text-center">{general:table:status}</th>
                            <th class="text-center text-muted" width="30"><i class="icon-checkmark3"></i></th>
                        </tr>
                    </thead>
                    {if isset($articles)}
                    <tbody class="selectable-demo-list articles_list" id="article_list">
                       
                        {foreach item=article from=$articles name=articles}
                        <tr id="article-{$article.articleId}" data-id="{$article.articleId}" class="{if $article.status eq 'hidden'}table-warning{/if}">
                        	<td class="text-nowrap">{$article.articleId}</td>
                         	<td class="text-nowrap">{$article.publishedOn|date_format:$config.date_format_custom}</td>
                            <td  class="text-center"><img src="{if isset($article.image)}{$article.image->small}{else}/admin/assets/img/no_images.jpg{/if}" class="img-preview" alt="{$article.title}"/></td>
                            <td><b>{$article.title|truncate:75}</b></td>
                            <td class="text-center">{$article.section.name|truncate:25}</td>
	                        <td class="text-center">{$article.typeNewsName}</td>
	                        <td class="text-center">{if $article.isFeatured}<i style="color:yellow;" class="icon-star-full2"></i>{else}<i class="icon-star-full2"></i>{/if}</td>
	                        <td class="text-center" id="status-{$article.articleId}">{$article.statusName nofilter}</td>
                            <td class="text-center">
                                <div class="list-icons">
	                                <a class="list-icons-item text-primary-600" data-popup="popover-solid" data-trigger="hover" title="{general:edit}" data-placement="top" href="{$adminUrl}/new?action=edit&id={$article.articleId}{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-pencil7"></i></a>
	                                <div class="list-icons-item dropdown">
									    <a href="#" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>
									    <div class="dropdown-menu dropdown-menu-right">
										    {if $article.status eq 'pending'}
                                            <a class="dropdown-item" id="article-approve-{$article.articleId}" href="javascript:void('')" style="color: #ec407a;" onclick="return approve({$article.articleId}, 'news');"><i class="icon-thumbs-up2"></i> {general:approve}</a>
                                            {/if}
										    <a href="{$article.url}" target="_blank" class="dropdown-item"><i class="icon-rotate-ccw2"></i> {general:view}</a>
    										<a class="dropdown-item" href="{$adminUrl}/new?action=edit&id={$article.articleId}{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-pencil7"></i>  {general:edit}</a>
    										<a href="#" class="dropdown-item ajax_action {if $article.status eq 'visible'}active_class{/if}" data-module="news" data-action="status" data-id="{$article.articleId}" name="status" value="1" ><i class="{if $article.status eq 'visible'}icon-eye{else}icon-eye-blocked{/if}"></i> {general:status}</a>
    										<div class="dropdown-divider"></div>
    										<a href="#" class="dropdown-item" onclick="remove({$article.articleId}, '{$article.title|escape}', 'news');"><i class="icon-cross2"></i> {general:delete}</a>
    									</div>
    								</div>
    							</div>
                            </td>
                        </tr>
                        {/foreach}
    
                    </tbody>
                {else}
                    <tbody><tr><td class="data none" colspan="9" align="center">- {general:none} -</td></tr></tbody>
                    {/if}
                </table>
	            </div>
                {include file="module/pagination.tpl" url="{$adminUrl}/news" params="{$buildQueryString}"}
            </div>
    	</div>
    </div>
</div>

<script>
    $(document).ready(function () {
      
        {if isset($messages.saved)} new Noty({ text: '{news:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}
        
        {if isset($errors.access_denied)} new Noty({ text: '{news:errors:0}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.not_saved)}   new Noty({ text: '{news:errors:3}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.no_sections)} new Noty({ text: '{news:errors:4}', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.article_not_found)} new Noty({ text: '{news:errors:6}', type: 'error', timeout: 2500 }).show(); {/if}
        
    });
    
    function deleteMessage(){
        new Noty({ text: '{news:messages:2}', type: 'success', timeout: 1500 }).show();
    }

    function deleteImageSuccess() {
        new Noty({ text: '{sections:messages:10}', type: 'success', timeout: 1500 }).show();
    }

    function approveSuccess(id) {
        document.getElementById('status-' + id).innerHTML = '{general:statuses:visible}';
        document.getElementById('article-approve-' + id).style.display = 'none';
        document.getElementById('article-status-' + id).innerHTML = '<i class="icon-eye"></i> {general:statuses:visible}';
        new Noty({ text: 'Контент одобрен без модерации', layout: 'topRight', type: 'success', timeout: 1500 }).show();
    }

</script>



