<form method="post" id="order">
    <div class="page-header page-header-light">
    	<div class="page-header-content header-elements-md-inline">
    		<div class="page-title d-flex">
    			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{orders:invoce} #{if isset($order->id)}{$order->id}{/if}</h4>
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    
    		<div class="header-elements d-none">
    			<div class="d-flex justify-content-center">
        			<button class="btn btn-sm btn-primary legitRipple" type="submit" name="action" value="save" >&nbsp;Изменить статус заказа &nbsp;</button>	&nbsp;
                    <a class="btn btn-sm btn-primary legitRipple" href="{$adminUrl}/orders">Вернуться к списку</a>
    			</div>
    		</div>
    	</div>
    
    	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
    		<div class="d-flex">
    			<div class="breadcrumb">
    				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
    				<a href="{$adminUrl}/orders" class="breadcrumb-item">{$title}</a>
    			</div>
    
    			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
    		</div>
    	</div>
    </div>

    <div class="content">
    	<div class="card">
    		<div class="card-header bg-transparent header-elements-inline">
    			<h6 class="card-title">Заказ</h6>
    			<div class="header-elements">
    {* 				<button type="button" class="btn btn-light btn-sm ml-3"><i class="icon-printer mr-2"></i> Print</button> *}
            	</div>
    		</div>
    
    		<div class="card-body">
    			<div class="row">
    				<div class="col-sm-8">
    					<div class="mb-4">
    						<h5>Продавец</h5>
                            <ul class="list list-unstyled mb-0">
                                <li>{$config.company_name}</li>
                                <li>Адрес: {$config.address}</li>
                                <li>Телефон: {$config.phone}</li>
                                <li>Email: {$config.email}</li>
    						</ul>
    					</div>
    				</div>
    
    				<div class="col-sm-4 mb-4">
					    <div class="text-sm-right">
						    <h4 class="text-primary mb-2 mt-md-2">Заказ #{if isset($order->id)}{$order->id}{/if}</h4>
						    <div class="d-flex flex-wrap wmin-md-400">
							    <ul class="list list-unstyled mb-0">
								    <li><h5 class="my-2">Общая сумма:</h5></li>
								    <li>Ф.И.О:</li>
								    <li>Телефон:</li>
								    <li>Возраст:</li>
								    <li>Стаж вождения:</li>
								    <li>Адрес:</li>
								    <li>Дата:</li>
							    </ul>

							    <ul class="list list-unstyled text-right mb-0 ml-auto">
                                    {if isset($order->id)}
								    <li><h5 class="font-weight-semibold my-2">{$order->amount|number_format:0:".":" "} сум</h5></li>
								    <li><span class="font-weight-semibold">{$order->client->fullName}</span></li>
								    <li>{if !empty($order->client->contact)}{$order->client->contact}{else} не указан{/if}</li>
								    <li>{if !empty($order->client->age)}{$order->client->age} л.{else} не указан{/if}</li>
								    <li>{if !empty($order->client->experience)}{$order->client->experience} л.{else} не указан{/if}</li>
								    <li>{if !empty($order->client->address)}{$order->client->address}{else} не указан{/if}</li>
								    <li><span class="font-weight-semibold">{$order->createdBy}</span></li>
								    {/if}
							    </ul>
						    </div>

    					</div>
    				</div>
    			</div>
    
    		</div>
    
    		<div class="table-responsive">
    		    <table class="table table-lg">
    		        <thead>
    		            <tr>
			                <th>Модель</th>
    		                <th>Дата получения</th>
			                <th>Дата возврата</th>
			                <th>Аренда дней</th>
			                <th>Детское кресло</th>
			                <th>Время доставки авто</th>
			                <th>Водитель</th>
    		                <th>Сумма к оплате онлайн</th>
    		                <th>Общая сумма</th>
    		            </tr>
    		        </thead>
    		        <tbody>
		            <tr>
			            <td>Класс: {$order->client->class}, {$order->client->mark} {$order->client->model}, {$order->client->year} г. выпуска<br>
				            Цена за сутки:</b> {$order->client->amount|number_format:0:".":" "} сум<br>
				            Депозит:</b> {$order->client->deposit|number_format:0:".":" "} сум
			            </td>
			            <td>{$order->client->start_date} {$order->client->start_time}</td>
			            <td>{$order->client->end_date} {$order->client->end_time}</td>
			            <td>{$order->client->days}</td>

			            <td>{$order->client->chair} шт. -  {$order->client->chair_amount|number_format:0:".":" "} сум</td>
			            <td>{$order->client->deliver}  -  {$order->client->deliver_amount|number_format:0:".":" "} сум</td>
			            <td>{$order->client->driver} д. -  {$order->client->driver_amount|number_format:0:".":" "} сум</td>

			            <td>{$order->client->paid_amount|number_format:0:".":" "} сум</td>
			            <td>{$order->client->total_amount|number_format:0:".":" "} сум</td>
		            </tr>
    		        </tbody>
    		    </table>
    		</div>
    
    		<div class="card-body">
    			<div class="d-md-flex flex-md-wrap">
    				<div class="pt-2 mb-3">
    					<h6>Комментарий к заказу</h6>
                        {if isset($order->message)}<p>{$order->message nofilter}</p>{/if}
    				</div>
                    {if isset($order->id)}
    				<div class="pt-2 mb-3 wmin-md-400 ml-auto">
    					<h6 class="mb-3">Сумма к оплате</h6>
    					<div class="table-responsive">
    						<table class="table">
    							<tbody>
    								<tr>
    									<th>Сумма к оплате:</th>
    									<td class="text-right">{if $order->client->paid_amount ne 0}{$order->client->paid_amount|number_format:2:".":" "} сум.{/if}</td>
    								</tr>
								    <tr>
									    <th>Аренда дней:</th>
									    <td class="text-right">{$order->client->days}.</td>
								    </tr>
    								<tr>
    									<th>Общая сумма:</th>
    									<td class="text-right text-primary"><h5 class="font-weight-semibold">{if $order->client->total_amount ne 0}{$order->client->total_amount|number_format:2:".":" "} сум.{/if}</h5></td>
    								</tr>
    							</tbody>
    						</table>
    						<div class="form-group">{orders:status}{html_options options=$statuses name="order[status]" id=brand selected=$order->status class="form-control select"}</div>
    					</div>
    
    					<div class="text-right mt-3">
        					<button class="btn btn-sm btn-primary" type="submit" name="action" value="save">&nbsp; Изменить статус заказа &nbsp;</button>
                            <a class="btn btn-sm btn-primary" href="{$adminUrl}/orders">Вернуться к списку</a>
    {* 						<button type="button" class="btn btn-primary btn-labeled btn-labeled-left"><b><i class="icon-paperplane"></i></b> Send invoice</button> *}
    					</div>
    				</div>
				    {/if}
    			</div>
    		</div>
    
    		<div class="card-footer">
    {* 			<span class="text-muted">Thank you for using Limitless. This invoice can be paid via PayPal, Bank transfer, Skrill or Payoneer. Payment is due within 30 days from the date of delivery. Late payment is possible, but with with a fee of 10% per month. Company registered in England and Wales #6893003, registered office: 3 Goodman Street, London E1 8BF, United Kingdom. Phone number: 888-555-2311</span> *}
    		</div>
    	</div>
    </div>

</form>

    <script>
        $(document).ready(function () {
          {if isset($messages.saved)} new Noty({ text: '{orders:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}
        });
        
        function deleteMessage(){ new Noty({ text: '{orders:messages:1}', type: 'success', timeout: 1500 }).show(); }
    </script>