<!-- Page header -->
<div class="page-header page-header-light">
	<div class="page-header-content header-elements-md-inline">
		<div class="page-title d-flex">
			<h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">{$title}</span></h4>
			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="d-flex justify-content-center">
				<a href="{$adminUrl}/overview" class="btn btn-link btn-float font-size-sm font-weight-semibold text-default legitRipple"><i class="icon-bars-alt text-pink-300"></i><span>Статистика</span></a>
			</div>
		</div>
	</div>

	<div class="breadcrumb-line breadcrumb-line-light header-elements-md-inline">
		<div class="d-flex">
			<div class="breadcrumb">
				<a href="{$adminUrl}/overview" class="breadcrumb-item"><i class="icon-home2 mr-2"></i> Статистика</a>
				<a href="{$adminUrl}/orders" class="breadcrumb-item">{$title}</a>
			</div>

			<a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
		</div>

		<div class="header-elements d-none">
			<div class="breadcrumb justify-content-center">
			</div>
		</div>
	</div>
</div>

<div class="content">
	<div class="row">
		<div class="col-md-12">
			<div class="card">
                {include file="stats/form/selectors.tpl" action="" select=''}
			</div>

			<div class="card">
				<div class="">
					<table class="table table-xs table-togglable table-striped table-hover" id="orders">
						<thead>
						<tr>
							<th data-hide="id" class="text-center" width="30">ID</th>
							<th data-toggle="true">Получатель</th>
							<th data-hide="phone" class="text-left">Дата заказа</th>
							<th data-hide="phone" class="text-center text-nowrap">Способ оплаты</th>
							<th data-hide="phone" class="text-center">На сумму</th>
							<th data-hide="status" class="text-center">Статус</th>
							<th class="text-center text-muted" width="30"><i class="icon-checkmark3"></i></th>
						</tr>
						</thead>
						{if $orders}
							<tbody>
		                    {foreach item=order from=$orders name=orders}
								<tr id="order-{$order->id}">
									<td class="text-center">{$order->id}</td>
									<td class="text-left" width="100%">
										<h6 class="mb-0"><a href="#">{$order->client->fullName nofilter}</a>
											<span class="d-block font-size-sm text-muted">Способ оплаты: {$order->payMethod}</span>
										</h6>
									</td>
									<td class="text-left text-nowrap">{$order->createdBy}</td>
									<td class="text-center text-nowrap"><img src="/payment/{$order->payMethod}/logo.png" style="width: 60px"></td>
									<td class="text-nowrap">{if $order->amount ne 0}{$order->amount} сум.{/if}</td>
									<td style="min-width: 120px;" class="text-center">{$order->status}</td>
									<td class="text-center">
										<div class="list-icons">
{*											<a class="list-icons-item read-order" href="javascript:void('')" data-id="{$order->id}" data-action="read_order" data-module="order"><i class="icon-file-eye"></i></a>*}
											<a class="list-icons-item text-primary-600" data-popup="popover-solid" data-trigger="hover" title="{general:view}" data-placement="top" href="{$adminUrl}/order?action=edit&id={$order->id}{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-pencil7"></i></a>
											<div class="list-icons-item dropdown">
												<a href="javascript:void('');" class="list-icons-item caret-0 dropdown-toggle" data-toggle="dropdown"><i class="icon-menu9"></i></a>
												<div class="dropdown-menu dropdown-menu-right">
													<a class="dropdown-item" href="{$adminUrl}/order?action=edit&id={$order->id}{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-pencil7"></i>  {general:view}</a>
													<div class="dropdown-divider"></div>
													<a href="javascript:void('')" class="dropdown-item" onclick="remove('{$order->id}','{$order->client->fullName|escape nofilter}', 'orders');"><i class="icon-cross2"></i> {general:delete}</a>
												</div>
											</div>
										</div>
									</td>
								</tr>
		                    {/foreach}
							</tbody>
		                {else}
							<tbody><tr class="odd"><td class="text-center" colspan="7">- {general:none} -</td></tr></tbody>
		                {/if}
						</table>
					</table>
				</div>
                {include file="module/pagination.tpl" url="{$adminUrl}/orders" params="{$buildQueryString}"}
			</div>
		</div>
	</div>

</div>

{include file='module/order_init.tpl'}


<script>
    function deleteSuccess(id) {
        removeElement(id, 'order');
        new Noty({ text: '{orders:messages:1}', type: 'success', timeout: 1500 }).show();
    }

    function deleteError(){
        new Noty({ text: '{orders:errors:1}', layout: 'topRight', type: 'error', timeout: 2500 }).show();
    }

    $(document).ready(function () {
        {if isset($messages.saved)} new Noty({ text: '{orders:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}
    });





//    var InvoiceArchive = function() {
//         // Datatable
//         var _componentDatatable = function() {
//             if (!$().DataTable) {
//                 console.warn('Warning - datatables.min.js is not loaded.');
//                 return;
//             }
//
//             // Initialize
//             $('.order-archive').DataTable({
//                 autoWidth: false,
//                 processing: true,
//                 serverSide: true,
//                 deferRender: true,
//                 stateSave: false,
//                ajax: { "url": "{$adminUrl}/orders?action=read_table", "type": 'POST' },
//                 'createdRow': function( row, data, dataIndex ) {
//                     // console.log(row);
//                     $(row).attr("data-id", data.id).attr("id", 'order-' + data.id);
//                 },
//                 columns: [
//                     { data: "id",
//                         render: function (dataField) {
//                             return "#" + dataField + "";
//                         }
//                     },
//                     { data: "monthBy",
//                         render: function (dataField) {
//                             return "" + dataField + "";
//                         }
//                     },
//                     { data: "client",
//                         render: function ( row, dataIndex, data ) {
//                             console.log(row)
//                             console.log(data)
//                             console.log(dataIndex)
//                             return '<h6 class="mb-0"><a href="#">' +row.fullName + '</a>' +
//                                 '<span class="d-block font-size-sm text-muted">Способ оплаты: ' + data.payMethod + '</span>' +
//                                 '</h6>';
//                         }
//                     },
//                     { data: "createdBy",
//                         render: function (dataField) {
//                             return "" + dataField + "";
//                         }
//                     },
//                     { data: "payMethod",
//                         render: function (dataField) {
//                             return `<img src="/payment/` + dataField + `/logo.png" style="width: 60px">`;
//                         }
//                     },
//                     { data: "amount",
//                         render: function (dataField) {
//                             return '<h6 class="mb-0 font-weight-bold">' + dataField + ' сум</h6>';
//                         }
//                     },
//                     { data: "status",
//                         render: function (data, type, row, meta) {
//                             var status = '';
//                             if (row.status === 'confirmed') {
//                                 status = 'badge-success';
//                             } else if (row.status === 'rejected') {
//                                 status = 'badge-warning';
//                             } else if (row.status === 'waiting'){
//                                 status = 'badge-primary';
//                             } else if (row.status === 'verification') {
//                                 status = 'badge-secondary';
//                             }
//
//                             return '<h6 class="mb-0 badge ' + status +'">' + row.statusName + '</h6>';
//                         }
//                     },
//                     { data: "id",
//                         render: function (dataField) {
//                             return ` <div class="list-icons list-icons-extended">
//                                                 <a class="list-icons-item read-order" href="javascript:void('')" data-id="` + dataField +`" data-action="read_order" data-module="order"><i class="icon-file-eye"></i></a>
//                                                 <div class="list-icons-item dropdown">
//                                                     <a href="javascript:void('')" class="list-icons-item dropdown-toggle" data-toggle="dropdown"><i class="icon-file-text2"></i></a>
//                                                     <div class="dropdown-menu dropdown-menu-right">
//                                                        <a class="dropdown-item" href="{$adminUrl}/order?action=edit&id=`+dataField+`"><i class="icon-pencil7"></i>  {general:edit}</a>
//                                                        <a href="javascript:void('')" class="dropdown-item" onclick="remove(`+ dataField +`, ` + dataField +`, 'orders');"><i class="icon-cross2"></i> {general:delete}</a>
//                                                     </div>
//                                                 </div>
//                                             </div>
//                                         `;
//                         }
//                     }
//                 ],
//                 columnDefs: [
//                     { width: 30, targets: 0 },
//                     { visible: false, targets: 1 },
//                     { orderable: false, width: 120, targets: 7 },
//                     { width: '15%', targets: [4, 5] },
//                     { width: '15%', targets: 6 },
//                     { width: '15%', targets: 3 }
//                 ],
//                 order: [[0, 'desc']],
//                 dom: '<"datatable-header"fl><"datatable-scroll-lg"t><"datatable-footer"ip>',
//                language: { "url": "{$GLOBAL_URL}/admin/assets/js/plugins/tables/datatables/lang/{$config.admin_language}.json" },
//                 lengthMenu: [10, 25, 50, 75, 100],
//                 displayLength: 10,
//                 drawCallback: function (settings) {
//                     var api = this.api();
//                     var rows = api.rows({ page: 'current' }).nodes();
//
//                     var last = null;
//                     api.column(1, {
//                         page: 'current'
//                     }).data().each(function (group, i) {
//                         if (last !== group) {
//                             $(rows).eq(i).before(
//                                 '<tr class="table-active table-border-double"><td colspan="8" class="font-weight-semibold">' + group + '</td></tr>'
//                             );
//
//                             last = group;
//                         }
//                     });
//
                    // Initializw Select2
                    // if (!$().select2) {
                    //     console.warn('Warning - select2.min.js is not loaded.');
                    //     return;
                    // }
                    // $('.form-control-select2').select2({
                    //     width: 150,
                    //     minimumResultsForSearch: Infinity
                    // });
                // }
            // });
        // };

        // Select2 for length menu styling
        // var _componentSelect2 = function() {
        //     if (!$().select2) {
        //         console.warn('Warning - select2.min.js is not loaded.');
        //         return;
        //     }
		//
            //Initialize
            // $('.dataTables_length select').select2({
            //     minimumResultsForSearch: Infinity,
            //     dropdownAutoWidth: true,
            //     width: 'auto'
            // });
        // };
		//
        // return {
        //     init: function() {
        //         _componentDatatable();
        //         _componentSelect2();
        //     }
        // }
    // }();
	//
    // document.addEventListener('DOMContentLoaded', function() {
    //     InvoiceArchive.init();
    // });

</script>






